/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.controller;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQQueueService;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/rabbitmq/queue"})
public class RabbitMQQueueController {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQQueueController.class);
    @Resource
    private RabbitMQQueueService rabbitMQQueueService;

    @GetMapping(value={"/queues"})
    public Mono<R<RabbitMQDataVo>> queryQues(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQQueueService.queryQue(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }
}

