/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.impl;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQConnectionService;
import io.github.pnoker.common.prometheus.service.PrometheusService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQConnectionServiceImpl
implements RabbitMQConnectionService {
    @Resource
    private PrometheusService prometheusService;

    @Override
    public RabbitMQDataVo queryConn(String cluster) {
        try {
            String promQLQuery = "sum(rabbitmq_connections * on(instance) group_left(rabbitmq_cluster) rabbitmq_identity_info{rabbitmq_cluster='" + cluster + "', namespace=''})";
            MapBuilder builder = MapUtil.builder();
            builder.put((Object)"query", (Object)promQLQuery);
            String jsonResponse = this.prometheusService.queryRange(builder.build());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(jsonResponse);
            JsonNode resultNode = rootNode.path("data").path("result").get(0);
            ArrayList<Double> values = new ArrayList<Double>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (int i = 0; i < 61; ++i) {
                long time = resultNode.path("values").get(i).get(0).asLong();
                times.add(time);
                Double ivalue = resultNode.path("values").get(i).get(1).asDouble();
                values.add(ivalue);
            }
            RabbitMQDataVo rabbitMQDataVo = new RabbitMQDataVo();
            rabbitMQDataVo.setTimes(times);
            rabbitMQDataVo.setValues(values);
            return rabbitMQDataVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

