/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.service;

import io.github.pnoker.common.exception.RequestException;
import jakarta.annotation.Resource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PrometheusService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusService.class);
    @Value(value="${prometheus.api.query}")
    private String queryApiUrl;
    @Value(value="${prometheus.api.query-range}")
    private String queryRangeApiUrl;
    @Resource
    private OkHttpClient okHttpClient;

    public String query(Map<String, String> params) {
        return this.getString(this.queryApiUrl, params);
    }

    public String queryRange(Map<String, String> params) {
        return this.getRangeString(this.queryRangeApiUrl, params);
    }

    private String getString(String api, Map<String, String> params) {
        try {
            HttpUrl url = HttpUrl.parse((String)api);
            if (Objects.isNull(url)) {
                throw new RequestException((CharSequence)"Request url empty", new Object[0]);
            }
            HttpUrl.Builder builder = url.newBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            Request request = new Request.Builder().url(builder.build()).get().build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (!response.isSuccessful() || Objects.isNull(response.body())) {
                throw new RequestException((CharSequence)"Request failed or empty response", new Object[0]);
            }
            return response.body().string();
        }
        catch (Exception e) {
            throw new RequestException((Throwable)e);
        }
    }

    private String getRangeString(String api, Map<String, String> params) {
        try {
            HttpUrl url = HttpUrl.parse((String)api);
            if (Objects.isNull(url)) {
                throw new RequestException((CharSequence)"Request url empty", new Object[0]);
            }
            HttpUrl.Builder builder = url.newBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
            LocalDateTime fifteenMinutesAgo = now.minusMinutes(15L);
            long time1 = fifteenMinutesAgo.toEpochSecond(ZoneOffset.UTC);
            long time2 = now.toEpochSecond(ZoneOffset.UTC);
            String rangeUrl = String.valueOf(builder.build()) + "&start=" + time1 + "&end=" + time2 + "&step=15";
            Request request = new Request.Builder().url(rangeUrl).get().build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (!response.isSuccessful() || Objects.isNull(response.body())) {
                throw new RequestException((CharSequence)"Request failed or empty response", new Object[0]);
            }
            return response.body().string();
        }
        catch (Exception e) {
            throw new RequestException((Throwable)e);
        }
    }

    public String UnTimeUnix(Double dtime) {
        Instant instant = Instant.ofEpochSecond(Math.round(dtime));
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = dateTime.format(formatter);
        return formattedDateTime;
    }
}

