/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ArithmeticUtil {
    private ArithmeticUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static BigDecimal add(String value1, String value2) {
        BigDecimal bigDecimal1 = new BigDecimal(value1);
        BigDecimal bigDecimal2 = new BigDecimal(value2);
        return bigDecimal1.add(bigDecimal2);
    }

    public static float add(float value1, float value2) {
        return ArithmeticUtil.add(Float.toString(value1), Float.toString(value2)).floatValue();
    }

    public static double add(double value1, double value2) {
        return ArithmeticUtil.add(Double.toString(value1), Double.toString(value2)).doubleValue();
    }

    public static BigDecimal subtract(String value1, String value2) {
        BigDecimal bigDecimal1 = new BigDecimal(value1);
        BigDecimal bigDecimal2 = new BigDecimal(value2);
        return bigDecimal1.subtract(bigDecimal2);
    }

    public static float subtract(float value1, float value2) {
        return ArithmeticUtil.subtract(Float.toString(value1), Float.toString(value2)).floatValue();
    }

    public static double subtract(double value1, double value2) {
        return ArithmeticUtil.subtract(Double.toString(value1), Double.toString(value2)).doubleValue();
    }

    public static BigDecimal multiply(String value1, String value2) {
        BigDecimal bigDecimal1 = new BigDecimal(value1);
        BigDecimal bigDecimal2 = new BigDecimal(value2);
        return bigDecimal1.multiply(bigDecimal2);
    }

    public static float multiply(float value1, float value2) {
        return ArithmeticUtil.multiply(Float.toString(value1), Float.toString(value2)).floatValue();
    }

    public static double multiply(double value1, double value2) {
        return ArithmeticUtil.multiply(Double.toString(value1), Double.toString(value2)).doubleValue();
    }

    public static BigDecimal divide(String value1, String value2, int scale) {
        BigDecimal bigDecimal1 = new BigDecimal(value1);
        BigDecimal bigDecimal2 = new BigDecimal(value2);
        return bigDecimal1.divide(bigDecimal2, scale, RoundingMode.HALF_UP);
    }

    public static float divide(float value1, float value2, int scale) {
        if (scale < 0 || scale > 7) {
            throw new IllegalArgumentException("The scale must be a positive integer(0 ~ 7)");
        }
        return ArithmeticUtil.divide(Float.toString(value1), Float.toString(value2), scale).floatValue();
    }

    public static double divide(double value1, double value2, int scale) {
        if (scale < 0 || scale > 16) {
            throw new IllegalArgumentException("The scale must be a positive integer(0 ~ 16)");
        }
        return ArithmeticUtil.divide(Double.toString(value1), Double.toString(value2), scale).doubleValue();
    }

    public static BigDecimal round(String value, int scale) {
        BigDecimal bigDecimal = new BigDecimal(value);
        BigDecimal tmp = new BigDecimal("1");
        return bigDecimal.divide(tmp, scale, RoundingMode.HALF_UP);
    }

    public static float round(float value, int scale) {
        if (scale < 0 || scale > 7) {
            throw new IllegalArgumentException("The scale must be a positive integer(0 ~ 7)");
        }
        return ArithmeticUtil.round(Float.toString(value), scale).floatValue();
    }

    public static double round(double value, int scale) {
        if (scale < 0 || scale > 16) {
            throw new IllegalArgumentException("The scale must be a positive integer(0 ~ 16)");
        }
        return ArithmeticUtil.round(Double.toString(value), scale).doubleValue();
    }
}

