/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.github.pnoker.common.exception.JsonException;
import io.github.pnoker.common.utils.DecodeUtil;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue())).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, Boolean.FALSE.booleanValue())).serializationInclusion(JsonInclude.Include.NON_NULL)).build();

    private JsonUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T parseObject(String text, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(text, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(JsonParser jsonParser, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonParser, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(DataInput dataInput, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(dataInput, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(InputStream inputStream, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(Reader reader, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(reader, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(File file, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(file, valueType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(text, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(bytes, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(JsonParser jsonParser, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(jsonParser, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(DataInput dataInput, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(dataInput, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(InputStream inputStream, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(inputStream, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(Reader reader, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(reader, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> List<T> parseArray(File file, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(file, javaType);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toJsonString(T type) {
        try {
            return OBJECT_MAPPER.writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toJsonString(T type, Class<?> serializationView) {
        try {
            return OBJECT_MAPPER.writerWithView(serializationView).writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toPrettyJsonString(T type) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> String toPrettyJsonString(T type, Class<?> serializationView) {
        try {
            return OBJECT_MAPPER.writerWithView(serializationView).withDefaultPrettyPrinter().writeValueAsString(type);
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static <T> byte[] toJsonBytes(T type) {
        try {
            return DecodeUtil.stringToByte(OBJECT_MAPPER.writeValueAsString(type));
        }
        catch (Exception e) {
            throw new JsonException((Throwable)e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }
}

