/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.util.ObjectUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiUtil {
    private static final Logger log = LoggerFactory.getLogger(PoiUtil.class);

    private PoiUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static CellStyle getCenterCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    public static void mergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        if (lastRow - firstRow < 1 && lastCol - firstCol < 1) {
            return;
        }
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public static String getCellStringValue(Sheet sheet, int rowIndex, int cellIndex) {
        Row driverAttributesRow = sheet.getRow(rowIndex);
        if (ObjectUtil.isNull((Object)driverAttributesRow)) {
            return "";
        }
        Cell driverAttributesCell = driverAttributesRow.getCell(cellIndex);
        if (ObjectUtil.isNull((Object)driverAttributesCell)) {
            return "";
        }
        DataFormatter formatter = new DataFormatter();
        return formatter.formatCellValue(driverAttributesCell);
    }

    public static void createCell(Row row, int cellIndex, String cellValue) {
        PoiUtil.createCellWithStyle(row, cellIndex, cellValue, null);
    }

    public static void createCellWithStyle(Row row, int cellIndex, String cellValue, CellStyle cellStyle) {
        Cell deviceNameCell = row.createCell(cellIndex);
        deviceNameCell.setCellValue(cellValue);
        if (ObjectUtil.isNotNull((Object)cellStyle)) {
            deviceNameCell.setCellStyle(cellStyle);
        }
    }
}

