/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.exception.NotFoundException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class KeyStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreUtil.class);

    private KeyStoreUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void importKeystore(String crtFileName, String crtNameAlias) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        String[] resourcePaths = new String[]{"classpath:/ssl/", "file:./ssl/"};
        String passphrase = "changeit";
        try (InputStream inputStream = KeyStoreUtil.getResource((ResourceLoader)resourceLoader, resourcePaths, crtFileName).getInputStream();){
            KeyStoreUtil.importKeystore(inputStream, crtNameAlias, passphrase);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private static Resource getResource(ResourceLoader resourceLoader, String[] resourcePaths, String fileName) {
        for (String path : resourcePaths) {
            Resource resource = resourceLoader.getResource(path + fileName);
            if (!resource.exists()) continue;
            return resource;
        }
        throw new NotFoundException((CharSequence)"Certificate file '{}' doesn't exist", new Object[]{fileName});
    }

    private static void importKeystore(InputStream crtInputStream, String crtAliasName, String passphrase) throws Exception {
        log.info("Importing certificate '{}'", (Object)crtAliasName);
        char separator = File.separatorChar;
        char[] passphraseArray = passphrase.toCharArray();
        File securityFile = new File(System.getProperty("java.home") + separator + "lib" + separator + "security");
        File keyStoreFile = new File(securityFile, "cacerts");
        Path path = keyStoreFile.toPath();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            keystore.load(inputStream, passphraseArray);
            if (keystore.containsAlias(crtAliasName)) {
                log.info("Skip import, certificate '{}' already exists", (Object)crtAliasName);
                return;
            }
        }
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            BufferedInputStream bis = new BufferedInputStream(crtInputStream);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                keystore.setCertificateEntry(crtAliasName, cert);
            }
            keystore.store(outputStream, passphraseArray);
        }
        log.info("Certificate '{}' imported successfully", (Object)crtAliasName);
    }
}

