/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.util.ReUtil;
import java.math.BigDecimal;

public class RegexUtil {
    private RegexUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNumeric(String content) {
        String regex = "-?[0-9]+(\\.[0-9]+)?";
        try {
            return ReUtil.isMatch((String)regex, (CharSequence)new BigDecimal(content).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isName(String name) {
        String regex = "^[A-Za-z0-9\\u4e00-\\u9fa5][A-Za-z0-9\\u4e00-\\u9fa5-_#@/.|]{1,31}$";
        return ReUtil.isMatch((String)regex, (CharSequence)name);
    }

    public static boolean isPhone(String phone) {
        String regex = "^1([3-9])\\d{9}$";
        return ReUtil.isMatch((String)regex, (CharSequence)phone);
    }

    public static boolean isMail(String mail) {
        String regex = "^[A-Za-z0-9_.-]+@[A-Za-z0-9]+\\.[A-Za-z0-9]+$";
        return ReUtil.isMatch((String)regex, (CharSequence)mail);
    }

    public static boolean isPassword(String password) {
        String regex = "^[a-zA-Z]\\w{7,15}$";
        return ReUtil.isMatch((String)regex, (CharSequence)password);
    }

    public static boolean isHost(String host) {
        String regex = "^((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}$";
        return ReUtil.isMatch((String)regex, (CharSequence)host);
    }

    public static boolean isDriverPort(int port) {
        String regex = "^8[6-7]\\d{2}$";
        return ReUtil.isMatch((String)regex, (CharSequence)String.valueOf(port));
    }
}

