/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.entity.common.TreeNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeUtil {
    private static final Logger log = LoggerFactory.getLogger(TreeUtil.class);

    public <T extends TreeNode> List<T> buildByLoop(List<T> treeNodes, Object root) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>(16);
        for (TreeNode treeNode : treeNodes) {
            if (root.equals(treeNode.getParentId())) {
                trees.add(treeNode);
            }
            for (TreeNode it : treeNodes) {
                if (it.getParentId() != treeNode.getId()) continue;
                if (treeNode.getChildren() == null) {
                    treeNode.setChildren(new ArrayList<TreeNode>(16));
                }
                treeNode.add(it);
            }
        }
        return trees;
    }

    public <T extends TreeNode> List<T> buildByRecursive(List<T> treeNodes, Object root) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>(16);
        for (TreeNode treeNode : treeNodes) {
            if (!root.equals(treeNode.getParentId())) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        return trees;
    }

    public <T extends TreeNode> T findChildren(T treeNode, List<T> treeNodes) {
        for (TreeNode it : treeNodes) {
            if (treeNode.getId() != it.getParentId()) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList<TreeNode>(16));
            }
            treeNode.add(this.findChildren(it, treeNodes));
        }
        return treeNode;
    }
}

