/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.quartz;

import jakarta.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QuartzService {
    private static final Logger log = LoggerFactory.getLogger(QuartzService.class);
    @Resource
    private Scheduler scheduler;

    public void createJobWithInterval(String group, String name, Integer interval, DateBuilder.IntervalUnit intervalUnit, Class<? extends Job> jobClass) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(name, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, group).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)intervalUnit)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(interval.intValue()).repeatForever()).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void createJobWithCron(String group, String name, String cron, Class<? extends Job> jobClass) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(name, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, group).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void startScheduler() throws SchedulerException {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.start();
        }
    }

    public void stopScheduler() throws SchedulerException {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
    }
}

