/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    private RedisTemplate redisTemplate;

    public <T> void setKey(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> void setKey(String key, T value, long time, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)key, value, time, unit);
    }

    public <T> void setKey(Map<String, T> valuesMap) {
        this.redisTemplate.opsForValue().multiSet(valuesMap);
    }

    public <T> void setKey(Map<String, T> valueMap, Map<String, Long> expireMillis) {
        this.redisTemplate.opsForValue().multiSet(valueMap);
        this.setExpire(expireMillis);
    }

    public <T> T getKey(String key) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        return (T)operations.get((Object)key);
    }

    public <T> List<T> getKey(List<String> keys) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        return operations.multiGet(keys);
    }

    public boolean hasKey(String key) {
        Boolean hasKey = this.redisTemplate.hasKey((Object)key);
        return Boolean.TRUE.equals(hasKey);
    }

    public Set<String> getKeys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public void deleteKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void deleteKey(List<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public void setExpire(String key, long time, TimeUnit unit) {
        if (time > 0L) {
            this.redisTemplate.expire((Object)key, time, unit);
        }
    }

    public void setExpire(Map<String, Long> expireMillis) {
        if (null != expireMillis && expireMillis.size() > 0) {
            StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
            this.redisTemplate.execute(connection -> {
                expireMillis.forEach((key, expire) -> {
                    byte[] serialize = stringRedisSerializer.serialize(key);
                    if (null != serialize) {
                        connection.pExpire(serialize, expire.longValue());
                    }
                });
                return null;
            });
        }
    }

    public void setExpireAt(String key, Date date) {
        Date current = new Date();
        if (date.getTime() >= current.getTime()) {
            this.redisTemplate.expireAt((Object)key, date);
        }
    }

    public long getExpire(String key, TimeUnit unit) {
        Long expire = this.redisTemplate.getExpire((Object)key, unit);
        if (null != expire) {
            return expire;
        }
        return 0L;
    }
}

