/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.redis.service;

import cn.hutool.core.collection.CollUtil;
import io.github.pnoker.common.entity.bo.PointValueBO;
import io.github.pnoker.common.redis.entity.builder.RedisPointValueBuilder;
import io.github.pnoker.common.redis.entity.model.RedisPointValueDO;
import io.github.pnoker.common.redis.service.RedisService;
import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(RedisRepositoryService.class);
    @Resource
    private RedisPointValueBuilder redisPointValueBuilder;
    @Resource
    private RedisService redisService;

    public void savePointValue(PointValueBO entityBO) {
        if (Objects.isNull(entityBO.getDeviceId()) || Objects.isNull(entityBO.getPointId())) {
            return;
        }
        String prefix = "point_value:" + entityBO.getDeviceId() + ".";
        RedisPointValueDO entityDO = this.redisPointValueBuilder.buildDOByBO(entityBO);
        this.redisService.setKey(prefix + entityBO.getPointId(), entityDO);
    }

    public void savePointValue(Long deviceId, List<PointValueBO> entityBOList) {
        if (Objects.isNull(deviceId)) {
            return;
        }
        String prefix = "point_value:" + deviceId + ".";
        List<RedisPointValueDO> entityDOList = this.redisPointValueBuilder.buildDOListByBOList(entityBOList);
        Map entityDOMap = entityDOList.stream().filter(entityBO -> Objects.nonNull(entityBO.getPointId())).collect(Collectors.toMap(entityBO -> prefix + entityBO.getPointId(), Function.identity()));
        this.redisService.setKey(entityDOMap);
    }

    public Map<Long, PointValueBO> selectLatestPointValue(Long deviceId, List<Long> pointIds) {
        if (CollUtil.isEmpty(pointIds)) {
            return Collections.emptyMap();
        }
        String prefix = "point_value:" + deviceId + ".";
        List<String> keys = pointIds.stream().map(pointId -> prefix + pointId).toList();
        List<RedisPointValueDO> entityDOList = this.redisService.getKey(keys);
        entityDOList = entityDOList.stream().filter(Objects::nonNull).toList();
        List<PointValueBO> entityBOList = this.redisPointValueBuilder.buildBOListByDOList(entityDOList);
        return entityBOList.stream().collect(Collectors.toMap(PointValueBO::getPointId, Function.identity()));
    }
}

