/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.entity.property.ThreadProperty;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="server")
public class ThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfig.class);
    private ThreadProperty thread;
    private final AtomicInteger threadPoolAtomic = new AtomicInteger(1);
    private final AtomicInteger scheduledThreadPoolAtomic = new AtomicInteger(1);

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        return new ThreadPoolExecutor(this.thread.getCorePoolSize(), this.thread.getMaximumPoolSize(), this.thread.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.thread.getMaximumPoolSize() * 2), r -> new Thread(r, "[T]" + this.thread.getPrefix() + this.threadPoolAtomic.getAndIncrement()), (r, e) -> new BlockingRejectedExecutionHandler());
    }

    @Bean
    public ScheduledThreadPoolExecutor scheduledThreadPoolExecutor() {
        return new ScheduledThreadPoolExecutor(this.thread.getCorePoolSize(), r -> new Thread(r, "[S]" + this.thread.getPrefix() + this.scheduledThreadPoolAtomic.getAndIncrement()), (r, e) -> new BlockingRejectedExecutionHandler());
    }

    public void setThread(ThreadProperty thread) {
        this.thread = thread;
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private BlockingRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            try {
                log.info("BlockingRejectedExecutionHandler: {}", (Object)executor.toString());
                if (!executor.isShutdown()) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                log.error("BlockingRejectedExecutionHandler: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

