/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.threadlocal.NamedThreadLocal;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.entity.bo.AuthInfoBO;
import io.github.pnoker.common.exception.NotFoundException;
import io.github.pnoker.common.exception.ServiceException;
import io.github.pnoker.common.exception.UnAuthorizedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);
    private static final ThreadLocal<AuthInfoBO> authInfoLocal = new NamedThreadLocal("Request auth info");

    private RequestUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getRequestHeader(HttpServletRequest request, String key) {
        return request.getHeader(key);
    }

    public static AuthInfoBO getAuthInfo() {
        AuthInfoBO entityBO = authInfoLocal.get();
        if (ObjectUtil.isNull((Object)entityBO)) {
            throw new UnAuthorizedException((CharSequence)"Unable to get auth info", new Object[0]);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)entityBO.getTenantId())) {
            throw new UnAuthorizedException((CharSequence)"Unable to get tenant id of auth info", new Object[0]);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)entityBO.getUserId())) {
            throw new UnAuthorizedException((CharSequence)"Unable to get user id of auth info", new Object[0]);
        }
        return entityBO;
    }

    public static void setAuthInfo(@Nullable AuthInfoBO entityBO) {
        if (ObjectUtil.isNull((Object)entityBO)) {
            RequestUtil.resetAuthInfo();
        } else {
            authInfoLocal.set(entityBO);
        }
    }

    public static void resetAuthInfo() {
        authInfoLocal.remove();
    }

    public static ResponseEntity<Resource> responseFile(Path path) throws MalformedURLException {
        UrlResource resource = new UrlResource(path.toUri());
        if (!resource.exists()) {
            throw new NotFoundException((CharSequence)("File not found: " + path.getFileName()), new Object[0]);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=" + resource.getFilename());
        headers.add("Content-Type", "application/octet-stream");
        try {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).body((Object)resource);
        }
        catch (IOException e) {
            throw new ServiceException((CharSequence)"Error occurred while response file: {}", new Object[]{path.getFileName()});
        }
    }
}

