/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.net.NetUtil;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    private RequestUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getRemoteIp(ServerHttpRequest request) {
        String[] headers;
        String ip = "";
        for (String header : headers = new String[]{"X-Original-Forwarded-For", "X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"}) {
            ip = request.getHeaders().getFirst(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        if (Objects.nonNull(remoteAddress)) {
            ip = remoteAddress.getHostString();
        }
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }

    public static String getRequestHeader(ServerHttpRequest request, String key) {
        return request.getHeaders().getFirst(key);
    }

    public static String getRequestCookie(ServerHttpRequest request, String key) {
        HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)key);
        return Objects.isNull(cookie) ? "" : cookie.getValue();
    }
}

