/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.exception.NotFoundException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class ResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtil.class);

    private ResponseUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ResponseEntity<Resource> responseFile(Path path) {
        try {
            UrlResource resource = new UrlResource(path.toUri());
            if (!resource.exists()) {
                throw new NotFoundException((CharSequence)("File not found: " + String.valueOf(path.getFileName())), new Object[0]);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=" + resource.getFilename());
            headers.add("Content-Type", "application/octet-stream");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).body((Object)resource);
        }
        catch (Exception e) {
            log.error("Error occurred while response file: {}, {}", new Object[]{path.getFileName(), e.getMessage(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }
}

