/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.config;

import io.github.pnoker.common.config.ExchangeConfig;
import io.github.pnoker.common.constant.driver.RabbitConstant;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.entity.property.DriverProperty;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={ExchangeConfig.class})
public class DriverTopicConfig {
    private static final Logger log = LoggerFactory.getLogger(DriverTopicConfig.class);
    @Resource
    private DriverProperty driverProperty;
    @Resource
    private DriverContext driverContext;
    @Resource
    private TopicExchange syncExchange;
    @Resource
    private TopicExchange metadataExchange;
    @Resource
    private TopicExchange commandExchange;

    @Bean
    Queue syncDownQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_SYNC_DOWN_PREFIX + this.driverProperty.getClient(), false, false, true, arguments);
    }

    @Bean
    Binding driverSyncBinding(Queue syncDownQueue) {
        Binding binding = BindingBuilder.bind((Queue)syncDownQueue).to(this.syncExchange).with("dc3.r.sync.down." + this.driverProperty.getClient());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }

    @Bean
    Queue driverMetadataQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DRIVER_METADATA_PREFIX + this.driverProperty.getClient(), false, false, true, arguments);
    }

    @Bean
    Binding driverMetadataBinding(Queue driverMetadataQueue) {
        Binding binding = BindingBuilder.bind((Queue)driverMetadataQueue).to(this.metadataExchange).with("dc3.r.metadata.driver." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }

    @Bean
    @Lazy
    Queue driverCommandQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DRIVER_COMMAND_PREFIX + this.driverProperty.getService(), false, false, true, arguments);
    }

    @Bean
    @Lazy
    Binding driverCommandBinding(Queue driverCommandQueue) {
        Binding binding = BindingBuilder.bind((Queue)driverCommandQueue).to(this.commandExchange).with("dc3.r.command.driver." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }

    @Bean
    Queue deviceCommandQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DEVICE_COMMAND_PREFIX + this.driverProperty.getService(), false, false, true, arguments);
    }

    @Bean
    Binding deviceCommandBinding(Queue deviceCommandQueue) {
        Binding binding = BindingBuilder.bind((Queue)deviceCommandQueue).to(this.commandExchange).with("dc3.r.command.device." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }
}

