/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.constant.driver.RabbitConstant;
import io.github.pnoker.common.dto.DriverSyncDownDTO;
import io.github.pnoker.common.dto.DriverSyncUpDTO;
import io.github.pnoker.common.entity.driver.DriverMetadata;
import io.github.pnoker.common.enums.DriverStatusEnum;
import io.github.pnoker.common.model.DriverDO;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.entity.property.DriverProperty;
import io.github.pnoker.driver.sdk.service.DriverSenderService;
import io.github.pnoker.driver.sdk.service.DriverSyncService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

@Service
public class DriverSyncServiceImpl
implements DriverSyncService {
    private static final Logger log = LoggerFactory.getLogger(DriverSyncServiceImpl.class);
    @Resource
    private DriverContext driverContext;
    @Resource
    private DriverProperty driverProperty;
    @Resource
    private DriverSenderService driverSenderService;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Override
    public void up() {
        try {
            DriverSyncUpDTO entityDTO = this.buildRegisterDTOByProperty();
            log.info("The driver {} is initializing", (Object)entityDTO.getClient());
            log.debug("The driver {} initialization information is: {}", (Object)this.driverProperty.getService(), (Object)JsonUtil.toPrettyJsonString((Object)entityDTO));
            this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_SYNC, "dc3.r.sync.up." + this.driverProperty.getClient(), (Object)entityDTO);
            this.threadPoolExecutor.submit(() -> {
                while (!DriverStatusEnum.ONLINE.equals((Object)this.driverContext.getDriverStatus())) {
                    ThreadUtil.sleep((long)500L);
                }
            }).get(15L, TimeUnit.SECONDS);
            log.info("The driver {} is initialized successfully.", (Object)entityDTO.getClient());
        }
        catch (Exception ignored) {
            log.error("The driver initialization failed, registration response timed out.");
            Thread.currentThread().interrupt();
            System.exit(1);
        }
    }

    @Override
    public void down(DriverSyncDownDTO entityDTO) {
        if (ObjectUtil.isNull((Object)entityDTO.getContent())) {
            return;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)entityDTO.getContent())) {
            return;
        }
        DriverMetadata driverMetadata = (DriverMetadata)JsonUtil.parseObject((String)entityDTO.getContent(), DriverMetadata.class);
        if (ObjectUtil.isNull((Object)driverMetadata)) {
            driverMetadata = new DriverMetadata();
        }
        this.driverContext.setDriverMetadata(driverMetadata);
        this.driverContext.setDriverStatus(DriverStatusEnum.ONLINE);
        driverMetadata.getDriverAttributeMap().values().forEach(driverAttribute -> log.info("Syncing driver attribute[{}] metadata: {}", (Object)driverAttribute.getAttributeName(), (Object)JsonUtil.toPrettyJsonString((Object)driverAttribute)));
        driverMetadata.getPointAttributeMap().values().forEach(pointAttribute -> log.info("Syncing point attribute[{}] metadata: {}", (Object)pointAttribute.getAttributeName(), (Object)JsonUtil.toPrettyJsonString((Object)pointAttribute)));
        driverMetadata.getDeviceMap().values().forEach(device -> log.info("Syncing device[{}] metadata: {}", (Object)device.getDeviceName(), (Object)JsonUtil.toPrettyJsonString((Object)device)));
        log.info("The metadata synced successfully.");
    }

    private DriverSyncUpDTO buildRegisterDTOByProperty() {
        DriverSyncUpDTO driverSyncUpDTO = new DriverSyncUpDTO();
        driverSyncUpDTO.setDriver(this.buildDriverByProperty());
        driverSyncUpDTO.setTenant(this.driverProperty.getTenant());
        driverSyncUpDTO.setClient(this.driverProperty.getClient());
        driverSyncUpDTO.setDriverAttributes(this.driverProperty.getDriverAttribute());
        driverSyncUpDTO.setPointAttributes(this.driverProperty.getPointAttribute());
        return driverSyncUpDTO;
    }

    private DriverDO buildDriverByProperty() {
        DriverDO entityDO = new DriverDO();
        entityDO.setDriverName(this.driverProperty.getName());
        entityDO.setDriverCode(this.driverProperty.getCode());
        entityDO.setServiceName(this.driverProperty.getService());
        entityDO.setServiceHost(this.driverProperty.getHost());
        entityDO.setDriverTypeFlag(this.driverProperty.getType());
        entityDO.setRemark(this.driverProperty.getRemark());
        return entityDO;
    }
}

