/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.job;

import io.github.pnoker.common.dto.DriverEventDTO;
import io.github.pnoker.common.enums.DriverEventTypeEnum;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.DriverContext;
import io.github.pnoker.driver.sdk.service.DriverSenderService;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DriverStatusScheduleJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DriverStatusScheduleJob.class);
    @Resource
    private DriverContext driverContext;
    @Resource
    private DriverSenderService driverSenderService;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        DriverEventDTO.DriverStatus driverStatus = new DriverEventDTO.DriverStatus(this.driverContext.getDriverMetadata().getDriverId(), this.driverContext.getDriverStatus());
        DriverEventDTO driverEventDTO = new DriverEventDTO(DriverEventTypeEnum.HEARTBEAT, JsonUtil.toJsonString((Object)driverStatus));
        log.debug("Send driver event: {}", (Object)JsonUtil.toJsonString((Object)driverEventDTO));
        this.driverSenderService.driverEventSender(driverEventDTO);
    }
}

