/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.rabbit;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.rabbitmq.client.Channel;
import io.github.pnoker.common.dto.DeviceCommandDTO;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.service.DriverCommandService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class DeviceCommandReceiver {
    private static final Logger log = LoggerFactory.getLogger(DeviceCommandReceiver.class);
    @Resource
    private DriverCommandService driverCommandService;

    @RabbitHandler
    @RabbitListener(queues={"#{deviceCommandQueue.name}"})
    public void deviceCommandReceive(Channel channel, Message message, DeviceCommandDTO entityDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.info("Receive device command: {}", (Object)JsonUtil.toPrettyJsonString((Object)entityDTO));
            if (ObjectUtil.isNull((Object)entityDTO) || ObjectUtil.isNull((Object)entityDTO.getType()) || CharSequenceUtil.isEmpty((CharSequence)entityDTO.getContent())) {
                log.error("Invalid device command: {}", (Object)entityDTO);
                return;
            }
            switch (entityDTO.getType()) {
                case READ: {
                    this.driverCommandService.read(entityDTO);
                    break;
                }
                case WRITE: {
                    this.driverCommandService.write(entityDTO);
                    break;
                }
                case CONFIG: {
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

