/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.service.rabbit;

import cn.hutool.core.util.ObjectUtil;
import com.rabbitmq.client.Channel;
import io.github.pnoker.common.dto.DriverSyncDownDTO;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.driver.sdk.service.DriverSyncService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class DriverSyncDownReceiver {
    private static final Logger log = LoggerFactory.getLogger(DriverSyncDownReceiver.class);
    @Resource
    private DriverSyncService driverSyncService;

    @RabbitHandler
    @RabbitListener(queues={"#{syncDownQueue.name}"})
    public void driverSyncDownReceive(Channel channel, Message message, DriverSyncDownDTO entityDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.debug("Receive driver sync down: {}", (Object)JsonUtil.toPrettyJsonString((Object)entityDTO));
            if (ObjectUtil.isNull((Object)entityDTO)) {
                log.error("Invalid driver sync down: {}", (Object)entityDTO);
                return;
            }
            this.driverSyncService.down(entityDTO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

