/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.utils;

import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.enums.PointTypeFlagEnum;
import io.github.pnoker.common.exception.EmptyException;
import io.github.pnoker.common.exception.OutRangeException;
import io.github.pnoker.common.model.Point;
import io.github.pnoker.common.utils.ArithmeticUtil;
import java.math.BigDecimal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(ConvertUtil.class);
    private static final BigDecimal defaultBase = new BigDecimal(0);
    private static final BigDecimal defaultMultiple = new BigDecimal(1);

    private ConvertUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String convertValue(Point point, String rawValue) {
        Comparable<Boolean> value;
        if (ObjectUtil.isNull((Object)point)) {
            throw new EmptyException((CharSequence)"Point is empty", new Object[0]);
        }
        PointTypeFlagEnum valueType = Optional.ofNullable(point.getPointTypeFlag()).orElse(PointTypeFlagEnum.STRING);
        BigDecimal base = Optional.ofNullable(point.getBaseValue()).orElse(defaultBase);
        BigDecimal multiple = Optional.ofNullable(point.getMultiple()).orElse(defaultMultiple);
        byte decimal = Optional.ofNullable(point.getValueDecimal()).orElse((byte)6);
        switch (valueType) {
            case BYTE: {
                value = ConvertUtil.convertByte(rawValue, base, multiple);
                break;
            }
            case SHORT: {
                value = ConvertUtil.convertShort(rawValue, base, multiple);
                break;
            }
            case INT: {
                value = ConvertUtil.convertInteger(rawValue, base, multiple);
                break;
            }
            case LONG: {
                value = ConvertUtil.convertLong(rawValue, base, multiple);
                break;
            }
            case FLOAT: {
                value = Float.valueOf(ConvertUtil.convertFloat(rawValue, base, multiple, decimal));
                break;
            }
            case DOUBLE: {
                value = ConvertUtil.convertDouble(rawValue, base, multiple, decimal);
                break;
            }
            case BOOLEAN: {
                value = ConvertUtil.convertBoolean(rawValue);
                break;
            }
            default: {
                return rawValue;
            }
        }
        return String.valueOf(value);
    }

    private static byte convertByte(String content, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            return multiply.byteValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of byte range: {} ~ {}, current: {}", new Object[]{(byte)-128, (byte)127, content});
        }
    }

    private static short convertShort(String content, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            return multiply.shortValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of short range: {} ~ {}, current: {}", new Object[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, content});
        }
    }

    private static int convertInteger(String content, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            return multiply.intValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of int range: {} ~ {}, current: {}", new Object[]{Integer.MIN_VALUE, Integer.MAX_VALUE, content});
        }
    }

    private static long convertLong(String content, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            return multiply.longValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of long range: {} ~ {}, current: {}", new Object[]{Long.MIN_VALUE, Long.MAX_VALUE, content});
        }
    }

    private static float convertFloat(String content, BigDecimal base, BigDecimal multiple, byte decimal) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            if (Float.isInfinite(multiply.floatValue())) {
                throw new OutRangeException();
            }
            return ArithmeticUtil.round((float)multiply.floatValue(), (int)decimal);
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of float range: |{} ~ {}|, current: {}", new Object[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), content});
        }
    }

    private static double convertDouble(String content, BigDecimal base, BigDecimal multiple, byte decimal) {
        try {
            BigDecimal multiply = ConvertUtil.linear(multiple, content, base);
            if (Double.isInfinite(multiply.doubleValue())) {
                throw new OutRangeException();
            }
            return ArithmeticUtil.round((double)multiply.doubleValue(), (int)decimal);
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of double range: |{} ~ {}|, current: {}", new Object[]{Double.MIN_VALUE, Double.MAX_VALUE, content});
        }
    }

    private static boolean convertBoolean(String content) {
        return Boolean.parseBoolean(content);
    }

    private static BigDecimal linear(BigDecimal a, String x, BigDecimal b) {
        BigDecimal bigDecimal = new BigDecimal(x);
        if (defaultMultiple.compareTo(a) == 0 && defaultBase.compareTo(b) == 0) {
            return bigDecimal;
        }
        if (defaultMultiple.compareTo(a) != 0 && defaultBase.compareTo(b) == 0) {
            return bigDecimal.multiply(a);
        }
        if (defaultMultiple.compareTo(a) == 0 && defaultBase.compareTo(b) != 0) {
            return bigDecimal.add(b);
        }
        BigDecimal multiply = a.multiply(bigDecimal);
        return multiply.add(b);
    }
}

