/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.driver.sdk.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import io.github.pnoker.common.entity.driver.AttributeInfo;
import io.github.pnoker.common.enums.PointTypeFlagEnum;
import io.github.pnoker.common.utils.DecodeUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverUtil {
    private static final Logger log = LoggerFactory.getLogger(DriverUtil.class);

    private DriverUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T attribute(Map<String, AttributeInfo> infoMap, String attribute) {
        return DriverUtil.value(infoMap.get(attribute).getType().getCode(), infoMap.get(attribute).getValue());
    }

    public static <T> T value(String type, String value) {
        return (T)Convert.convertByClassName((String)DriverUtil.getTypeClassName(type), (Object)value);
    }

    public static String base64Encode(String content) {
        byte[] bytes = DecodeUtil.stringToByte((String)content);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String base64Decode(String content) {
        byte[] bytes = DecodeUtil.stringToByte((String)content);
        return new String(Base64.getDecoder().decode(bytes));
    }

    public static String bcdBytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append((byte)((bytes[i] & 0xF0) >>> 4));
            sb.append((byte)(bytes[i] & 0xF));
        }
        return sb.toString().substring(0, 1).equalsIgnoreCase("0") ? sb.toString().substring(1) : sb.toString();
    }

    public static byte[] strToBcdBytes(String decimalString) {
        int length = decimalString.length();
        int mod = length % 2;
        if (mod != 0) {
            decimalString = "0" + decimalString;
            length = decimalString.length();
        }
        if (length >= 2) {
            length /= 2;
        }
        byte[] bcdBytes = new byte[length];
        byte[] decimalBytes = DecodeUtil.stringToByte((String)decimalString);
        for (int i = 0; i < decimalString.length() / 2; ++i) {
            int j = decimalBytes[2 * i] >= 48 && decimalBytes[2 * i] <= 57 ? decimalBytes[2 * i] - 48 : (decimalBytes[2 * i] >= 97 && decimalBytes[2 * i] <= 122 ? decimalBytes[2 * i] - 97 + 10 : decimalBytes[2 * i] - 65 + 10);
            int k = decimalBytes[2 * i + 1] >= 48 && decimalBytes[2 * i + 1] <= 57 ? decimalBytes[2 * i + 1] - 48 : (decimalBytes[2 * i + 1] >= 97 && decimalBytes[2 * i + 1] <= 122 ? decimalBytes[2 * i + 1] - 97 + 10 : decimalBytes[2 * i + 1] - 65 + 10);
            bcdBytes[i] = (byte)((j << 4) + k);
        }
        return bcdBytes;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static int bytesToInt(byte[] bytes) {
        byte[] temp = new byte[4];
        int length = bytes.length;
        System.arraycopy(bytes, 0, temp, 0, length);
        for (int i = length; i < 4; ++i) {
            temp[i] = 0;
        }
        int int1 = temp[3] & 0xFF;
        int int2 = (temp[2] & 0xFF) << 8;
        int int3 = (temp[1] & 0xFF) << 16;
        int int4 = (temp[0] & 0xFF) << 24;
        return int1 | int2 | int3 | int4;
    }

    public static int bytesToIntLE(byte[] bytes) {
        byte[] temp = new byte[4];
        int length = bytes.length;
        System.arraycopy(bytes, 0, temp, 0, length);
        for (int i = length; i < 4; ++i) {
            temp[i] = 0;
        }
        int int1 = temp[0] & 0xFF;
        int int2 = (temp[1] & 0xFF) << 8;
        int int3 = (temp[2] & 0xFF) << 16;
        int int4 = (temp[3] & 0xFF) << 24;
        return int1 | int2 | int3 | int4;
    }

    public static String bytesToAscii(byte[] bytes) {
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public static byte[] byteReverse(byte[] bytes) {
        int length = bytes.length;
        byte[] reverse = new byte[length];
        for (int i = 0; i < length; ++i) {
            reverse[length - 1 - i] = bytes[i];
        }
        return reverse;
    }

    public static byte[] mergerBytes(byte[] ... bytes) {
        int lengthByte = 0;
        for (byte[] value : bytes) {
            lengthByte += value.length;
        }
        byte[] allByte = new byte[lengthByte];
        int countLength = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, allByte, countLength, b.length);
            countLength += b.length;
        }
        return allByte;
    }

    public static byte xorBytes(byte[] ... bytes) {
        byte xor = 0;
        byte[][] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] value;
            for (byte b : value = byArray[i]) {
                xor = (byte)(xor ^ b);
            }
        }
        return xor;
    }

    public static byte sumBytes(byte[] ... bytes) {
        byte xor = 0;
        byte[][] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] value;
            for (byte b : value = byArray[i]) {
                xor = (byte)(xor + b);
            }
        }
        return xor;
    }

    public static String getTypeClassName(String type) {
        String className = String.class.getName();
        PointTypeFlagEnum valueType = PointTypeFlagEnum.ofCode((String)type);
        if (ObjectUtil.isNull((Object)valueType)) {
            throw new IllegalArgumentException("Unsupported type of " + type);
        }
        switch (valueType) {
            case BYTE: {
                className = Byte.class.getName();
                break;
            }
            case SHORT: {
                className = Short.class.getName();
                break;
            }
            case INT: {
                className = Integer.class.getName();
                break;
            }
            case LONG: {
                className = Long.class.getName();
                break;
            }
            case FLOAT: {
                className = Float.class.getName();
                break;
            }
            case DOUBLE: {
                className = Double.class.getName();
                break;
            }
            case BOOLEAN: {
                className = Boolean.class.getName();
                break;
            }
        }
        return className;
    }
}

