/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.crypto;

import io.github.ppzxc.crypto.TransformationMode;
import io.github.ppzxc.crypto.TransformationPkcs;
import io.github.ppzxc.crypto.TransformationType;
import java.util.Arrays;

public enum Transformation {
    RSA(TransformationType.RSA, null, null),
    AES_ECB_PKCS5PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.ELECTRONIC_CODE_BLOCK, TransformationPkcs.PKCS5PADDING),
    AES_ECB_PKCS7PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.ELECTRONIC_CODE_BLOCK, TransformationPkcs.PKCS7PADDING),
    AES_CBC_PKCS5PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.CIPHER_BLOCK_CHAINING, TransformationPkcs.PKCS5PADDING),
    AES_CBC_PKCS7PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.CIPHER_BLOCK_CHAINING, TransformationPkcs.PKCS7PADDING),
    AES_CFB_PKCS5PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.CIPHER_FEEDBACK, TransformationPkcs.PKCS5PADDING),
    AES_CFB_PKCS7PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.CIPHER_FEEDBACK, TransformationPkcs.PKCS7PADDING),
    AES_OFB_PKCS5PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.OUTPUT_FEEDBACK, TransformationPkcs.PKCS5PADDING),
    AES_OFB_PKCS7PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.OUTPUT_FEEDBACK, TransformationPkcs.PKCS7PADDING),
    AES_CTR_PKCS5PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.COUNTER, TransformationPkcs.PKCS5PADDING),
    AES_CTR_PKCS7PADDING(TransformationType.ADVANCED_ENCRYPTION_STANDARD, TransformationMode.COUNTER, TransformationPkcs.PKCS7PADDING);

    private final TransformationType transformationType;
    private final TransformationMode transformationMode;
    private final TransformationPkcs transformationPkcs;

    private Transformation(TransformationType transformationType, TransformationMode transformationMode, TransformationPkcs transformationPkcs) {
        this.transformationType = transformationType;
        this.transformationMode = transformationMode;
        this.transformationPkcs = transformationPkcs;
    }

    public String getCode() {
        if (this.transformationType == TransformationType.RSA) {
            return this.transformationType.getCode();
        }
        return String.format("%s/%s/%s", this.transformationType.getCode(), this.transformationMode.getCode(), this.transformationPkcs.getCode());
    }

    public static Transformation of(String type, String mode, String pkcs) {
        return Arrays.stream(Transformation.values()).filter(tran -> tran.transformationType.getCode().equalsIgnoreCase(type)).filter(tran -> tran.transformationMode == null || tran.transformationMode.getCode().equalsIgnoreCase(mode)).filter(tran -> tran.transformationPkcs == null || tran.transformationPkcs.getCode().equalsIgnoreCase(pkcs)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("type=%s mode=%s pkcs=%s not supported transformation", type, mode, pkcs)));
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public TransformationMode getTransformationMode() {
        return this.transformationMode;
    }

    public TransformationPkcs getTransformationPkcs() {
        return this.transformationPkcs;
    }
}

