/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.crypto;

import io.github.ppzxc.crypto.AsymmetricKey;
import io.github.ppzxc.crypto.CryptoException;
import io.github.ppzxc.crypto.CryptoProvider;
import io.github.ppzxc.crypto.CryptoSecureRandom;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.function.Function;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public final class AsymmetricKeyFactory {
    public static final CryptoProvider CRYPTO_PROVIDER = CryptoProvider.BOUNCY_CASTLE;
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final String DEFAULT_PUBLIC_KEY_COMMENT = "PUBLIC KEY";
    public static final String DEFAULT_PRIVATE_RSA_KEY_COMMENT = "RSA PRIVATE KEY";

    private AsymmetricKeyFactory() {
    }

    public static KeyPair generate(AsymmetricKey.Type type, CryptoProvider cryptoProvider, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(type.name(), cryptoProvider.getCode());
        generator.initialize(keySize, CryptoSecureRandom.getSecureRandom());
        return generator.generateKeyPair();
    }

    public static KeyPair generate(AsymmetricKey asymmetricKey) throws CryptoException {
        return new KeyPair(AsymmetricKeyFactory.toPublicKey(asymmetricKey.getType(), asymmetricKey.getPublicKey(), X509EncodedKeySpec::new), AsymmetricKeyFactory.toPrivateKey(asymmetricKey.getType(), asymmetricKey.getPrivateKey(), PKCS8EncodedKeySpec::new));
    }

    public static AsymmetricKey generate(AsymmetricKey.Type type) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return AsymmetricKeyFactory.toAsymmetricKey(type, AsymmetricKeyFactory.generateRsa());
    }

    public static KeyPair generateRsa() throws NoSuchAlgorithmException, NoSuchProviderException {
        return AsymmetricKeyFactory.generate(AsymmetricKey.Type.RSA, CRYPTO_PROVIDER, 2048);
    }

    public static KeyPair generateRsa(int length) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AsymmetricKeyFactory.generate(AsymmetricKey.Type.RSA, CRYPTO_PROVIDER, length);
    }

    public static PublicKey toPublicKey(AsymmetricKey.Type type, String publicKey, Function<byte[], EncodedKeySpec> encodedKeySpec) throws CryptoException {
        PublicKey publicKey2;
        PemReader pemReader = new PemReader((Reader)new StringReader(publicKey));
        try {
            publicKey2 = KeyFactory.getInstance(type.name()).generatePublic(encodedKeySpec.apply(pemReader.readPemObject().getContent()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
        }
        pemReader.close();
        return publicKey2;
    }

    public static PrivateKey toPrivateKey(AsymmetricKey.Type type, String privateKey, Function<byte[], EncodedKeySpec> encodedKeySpec) throws CryptoException {
        PrivateKey privateKey2;
        PemReader pemReader = new PemReader((Reader)new StringReader(privateKey));
        try {
            privateKey2 = KeyFactory.getInstance(type.name()).generatePrivate(encodedKeySpec.apply(pemReader.readPemObject().getContent()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
        }
        pemReader.close();
        return privateKey2;
    }

    public static AsymmetricKey toAsymmetricKey(AsymmetricKey.Type type, KeyPair keyPair) throws IOException {
        return AsymmetricKey.of(type, AsymmetricKeyFactory.writeToString(DEFAULT_PUBLIC_KEY_COMMENT, keyPair.getPublic().getEncoded()), AsymmetricKeyFactory.writeToString(DEFAULT_PRIVATE_RSA_KEY_COMMENT, keyPair.getPrivate().getEncoded()));
    }

    private static String writeToString(String desc, byte[] key) throws IOException {
        PemObject pemObject = new PemObject(desc, key);
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)pemObject);
        pemWriter.close();
        return stringWriter.toString();
    }
}

