/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.crypto;

import io.github.ppzxc.crypto.CryptoProvider;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public final class CryptoSecureRandom {
    private static final String SHA_1_PRNG = "SHA1PRNG";

    private CryptoSecureRandom() {
    }

    public static SecureRandom getSecureRandom(String algorithm, String provider) {
        try {
            return SecureRandom.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecureRandom getSecureRandom(String algorithm) {
        try {
            return SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecureRandom getSecureRandom(String algorithm, CryptoProvider cryptoProvider) {
        return CryptoSecureRandom.getSecureRandom(algorithm, cryptoProvider.getCode());
    }

    public static SecureRandom getSecureRandom() {
        return CryptoSecureRandom.getSecureRandom(SHA_1_PRNG);
    }
}

