/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.crypto;

import io.github.ppzxc.crypto.Crypto;
import io.github.ppzxc.crypto.CryptoException;
import io.github.ppzxc.crypto.CryptoProvider;
import io.github.ppzxc.crypto.Transformation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

public final class RsaCrypto
implements Crypto {
    private final Transformation transformation;
    private final CryptoProvider cryptoProvider;
    private final Charset charset;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    private RsaCrypto(Transformation transformation, CryptoProvider cryptoProvider, Charset charset, PublicKey publicKey, PrivateKey privateKey) {
        this.transformation = transformation;
        this.cryptoProvider = cryptoProvider;
        this.charset = charset;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] encrypt(byte[] plainText) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation.getCode(), this.cryptoProvider.getCode());
            cipher.init(1, this.publicKey);
            return Base64.encode((byte[])cipher.doFinal(plainText));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] encrypt(String plainText) throws CryptoException {
        return this.encrypt(plainText.getBytes(this.charset));
    }

    @Override
    public String encryptToString(byte[] plainText) throws CryptoException {
        return new String(this.encrypt(plainText), this.charset);
    }

    @Override
    public String encryptToString(String plainText) throws CryptoException {
        return new String(this.encrypt(plainText.getBytes(this.charset)), this.charset);
    }

    @Override
    public byte[] decrypt(byte[] cipherText) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(this.transformation.getCode(), this.cryptoProvider.getCode());
            cipher.init(2, this.privateKey);
            return cipher.doFinal(Base64.decode((byte[])cipherText));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] decrypt(String cipherText) throws CryptoException {
        return this.decrypt(cipherText.getBytes(this.charset));
    }

    @Override
    public String decryptToString(byte[] cipherText) throws CryptoException {
        return new String(this.decrypt(cipherText), this.charset);
    }

    @Override
    public String decryptToString(String cipherText) throws CryptoException {
        return new String(this.decrypt(cipherText.getBytes(this.charset)), this.charset);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Transformation transformation = Transformation.RSA_ECB_PKCS1PADDING;
        private CryptoProvider cryptoProvider = CryptoProvider.BOUNCY_CASTLE;
        private Charset charset = StandardCharsets.UTF_8;
        private PublicKey publicKey;
        private PrivateKey privateKey;

        Builder() {
        }

        public Builder transformation(Transformation transformation) {
            if (transformation == null) {
                throw new NullPointerException("transformation is marked non-null but is null");
            }
            this.transformation = transformation;
            return this;
        }

        public Builder cryptoProvider(CryptoProvider cryptoProvider) {
            if (cryptoProvider == null) {
                throw new NullPointerException("cryptoProvider is marked non-null but is null");
            }
            this.cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder charset(Charset charset) {
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            this.charset = charset;
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.publicKey = publicKey;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            if (privateKey == null) {
                throw new NullPointerException("privateKey is marked non-null but is null");
            }
            this.privateKey = privateKey;
            return this;
        }

        public RsaCrypto build() {
            return new RsaCrypto(this.transformation, this.cryptoProvider, this.charset, this.publicKey, this.privateKey);
        }
    }
}

