/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.fixh;

import io.github.ppzxc.fixh.FixhConstants;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static String lengthToHumanReadable(long v) {
        if (v < 1024L) {
            return v + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        return String.format("%.1f %sB", (double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static byte getAscii() {
        return (byte)ThreadLocalRandom.current().nextInt(0, 127);
    }

    public static byte getNegative() {
        return (byte)ThreadLocalRandom.current().nextInt(-128, -1);
    }

    public static byte getPositive() {
        return (byte)Math.abs(ThreadLocalRandom.current().nextInt(1, 127));
    }

    public static short getUnsignedBoundary() {
        return (short)ThreadLocalRandom.current().nextInt(0, 255);
    }

    public static short getGreaterThanUnsignedByteMaxValue() {
        return (short)ThreadLocalRandom.current().nextInt(256, Short.MAX_VALUE);
    }

    public static byte giveMeOneWithout(byte without) {
        byte given;
        while (without == (given = ByteUtils.giveMeOne())) {
        }
        return given;
    }

    public static byte giveMeOneWithout(List<Byte> without) {
        int given;
        do {
            given = ThreadLocalRandom.current().nextInt(-128, 127);
        } while (!without.stream().noneMatch(b -> b == given));
        return (byte)given;
    }

    public static byte giveMeOne() {
        byte[] given = new byte[1];
        FixhConstants.SECURE_RANDOM.nextBytes(given);
        return given[0];
    }
}

