/*
 * Decompiled with CFR 0.152.
 */
package io.github.ppzxc.fixh;

import io.github.ppzxc.fixh.FixhConstants;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isBlank(String src) {
        return src == null || src.isEmpty() || src.trim().isEmpty();
    }

    public static boolean isNotBlank(String src) {
        return !StringUtils.isBlank(src);
    }

    public static String nvl(String src) {
        return StringUtils.isNull(src) ? "" : src;
    }

    public static boolean isNull(String src) {
        return src == null;
    }

    public static boolean isNotNull(String src) {
        return !StringUtils.isNull(src);
    }

    public static boolean isEmpty(String src) {
        return src == null || src.isEmpty();
    }

    public static boolean isNotEmpty(String src) {
        return !StringUtils.isEmpty(src);
    }

    public static String isEmptyToDefault(String src, String def) {
        return StringUtils.isEmpty(src) ? def : src;
    }

    public static String getCurrentPath() throws IOException {
        return new File(".").getCanonicalFile().getPath();
    }

    public static void requiredNonBlank(String given) {
        if (StringUtils.isBlank(given)) {
            throw new IllegalArgumentException("input is blank");
        }
    }

    public static String leftPad(String type, int i, String space) {
        return StringUtils.padding(type, i, space) + type;
    }

    public static String rightPad(String type, int i, String space) {
        return type + StringUtils.padding(type, i, space);
    }

    private static String padding(String type, int i, String space) {
        if (type.length() >= i) {
            return type;
        }
        return IntStream.range(0, i - type.length()).mapToObj(j -> space).collect(Collectors.joining());
    }

    public static String join(String ... paths) {
        return String.join((CharSequence)"", paths);
    }

    public static String lowerCase(int length) {
        int leftLimit = 97;
        int rightLimit = 122;
        return IntStream.range(0, length).mapToObj(i -> String.valueOf((char)(leftLimit + (int)(FixhConstants.SECURE_RANDOM.nextFloat() * (float)(rightLimit - leftLimit + 1))))).collect(Collectors.joining());
    }

    public static String giveMeOne() {
        return StringUtils.giveMeOne(512);
    }

    public static String giveMeOne(int origin, int bound) {
        return StringUtils.giveMeOne(ThreadLocalRandom.current().nextInt(origin, bound));
    }

    public static String giveMeOne(int origin, int bound, int ... without) {
        int givenSize;
        do {
            givenSize = ThreadLocalRandom.current().nextInt(origin, bound);
        } while (!Arrays.stream(without).noneMatch(w -> w == givenSize));
        return StringUtils.giveMeOne(givenSize);
    }

    public static String giveMeOne(int length) {
        int leftLimit = 97;
        int rightLimit = 122;
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomLimitedInt = leftLimit + (int)(FixhConstants.SECURE_RANDOM.nextFloat() * (float)(rightLimit - leftLimit + 1));
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }

    public static void requireNotNull(String given) {
        if (StringUtils.isNull(given)) {
            throw new IllegalArgumentException("required not null");
        }
    }

    public static void requireNotBlank(String given) {
        if (StringUtils.isBlank(given)) {
            throw new IllegalArgumentException("required not blank");
        }
    }

    public static void requireNotEmpty(String given) {
        if (StringUtils.isEmpty(given)) {
            throw new IllegalArgumentException("required not empty");
        }
    }

    public static String requireNonNull(String value, RuntimeException exception) {
        if (value == null) {
            throw exception;
        }
        return value;
    }

    public static String requireNonEmpty(String value, RuntimeException exception) {
        if (StringUtils.requireNonNull(value, exception).isEmpty()) {
            throw exception;
        }
        return value;
    }

    public static String requireNonBlank(String value, RuntimeException exception) {
        if (StringUtils.requireNonEmpty(value, exception).trim().isEmpty()) {
            throw exception;
        }
        return value;
    }
}

