/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.junit;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteCallbacks;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.junit.CourgetteJUnitRunner;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.internal.gherkin.pickles.PickleLocation;
import java.util.ArrayList;
import java.util.Map;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class Courgette
extends CourgetteJUnitRunner {
    public Courgette(Class clazz) throws InitializationError {
        super(clazz);
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(clazz);
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, this.createSessionId(), courgetteOptions.threads());
        this.callbacks = new CourgetteCallbacks(clazz);
        CourgetteLoader courgetteLoader = new CourgetteLoader(this.courgetteProperties);
        this.features = courgetteLoader.getFeatures();
        this.runnerInfoList = new ArrayList();
        if (courgetteOptions.runLevel().equals((Object)CourgetteRunLevel.FEATURE)) {
            this.features.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)feature, null)));
        } else {
            Map<PickleLocation, Feature> scenarios = courgetteLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)scenarios.get(location), location.getLine())));
        }
    }

    public void run(RunNotifier notifier) {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        try {
            this.callbacks.beforeAll();
            if (courgetteRunner.canRunFeatures()) {
                courgetteRunner.run();
                courgetteRunner.createReport();
                courgetteRunner.createCourgetteReport();
                if (this.courgetteProperties.isExtentReportsPluginEnabled()) {
                    courgetteRunner.createCourgetteExtentReports();
                }
                if (this.courgetteProperties.isReportPortalPluginEnabled()) {
                    courgetteRunner.publishReportToReportPortal();
                }
            }
            if (courgetteRunner.hasFailures()) {
                courgetteRunner.createRerunFile();
            }
            courgetteRunner.cleanupCourgetteHtmlReportFiles();
        }
        finally {
            this.callbacks.afterAll();
            this.notifyTestStarted(notifier);
            this.notifyTestFailure(notifier, courgetteRunner.getFailures());
            this.notifyTestSuccess(notifier);
        }
    }
}

