/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal;

import courgette.integration.reportportal.ReportPortalProperties;
import courgette.runtime.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ReportPortalService {
    private ReportPortalProperties reportPortalProperties;
    private final String API_RESOURCE = "api/v1/%s/launch/import";

    private ReportPortalService(ReportPortalProperties reportPortalProperties) {
        this.reportPortalProperties = reportPortalProperties;
    }

    public static ReportPortalService create(ReportPortalProperties reportPortalProperties) {
        return new ReportPortalService(reportPortalProperties);
    }

    public void publishReport(String reportFilename) {
        HttpResponse response;
        String projectEndpoint = this.reportPortalProperties.getEndpoint() + String.format("api/v1/%s/launch/import", this.reportPortalProperties.getProject());
        String authorization = "bearer " + this.reportPortalProperties.getApiToken();
        File zipFile = FileUtils.zipFile(reportFilename, true);
        if (zipFile.exists() && (response = this.sendMultiPartPost(projectEndpoint, authorization, zipFile)) != null && response.getStatusLine().getStatusCode() != 200) {
            String body;
            try {
                body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (IOException e) {
                body = e.getMessage();
            }
            System.err.format("Unable to send the report to report portal server, reason: %s", body);
        }
    }

    private HttpResponse sendMultiPartPost(String url, String authorization, File file) {
        try {
            SSLContext trustedSSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(trustedSSLContext).build();
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", file).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Authorization", authorization);
            httpPost.setEntity(entity);
            return httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            System.err.format("Unable to send the report to report portal server, reason: %s", e.getMessage());
            return null;
        }
    }
}

