/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.utils.SystemPropertyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CourgetteFeatureRunner {
    private Map<String, List<String>> runnerArgs;
    private Boolean output;

    public CourgetteFeatureRunner(Map<String, List<String>> runnerArgs, Boolean output) {
        this.runnerArgs = runnerArgs;
        this.output = output;
    }

    public int run() {
        Process process = null;
        try {
            ProcessBuilder builder = new Builder().buildProcess();
            process = builder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return process != null ? process.exitValue() : -1;
    }

    class Builder {
        Builder() {
        }

        ProcessBuilder buildProcess() {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (CourgetteFeatureRunner.this.output.booleanValue()) {
                builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            builder.redirectErrorStream(true);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("java");
            SystemPropertyUtils.splitAndAddPropertyToList("courgette.vmoptions", commands);
            commands.addAll(this.getSystemProperties());
            commands.add("io.cucumber.core.cli.Main");
            CourgetteFeatureRunner.this.runnerArgs.forEach((key, value) -> commands.addAll((Collection<String>)value));
            builder.command(commands);
            return builder;
        }

        private List<String> getSystemProperties() {
            ArrayList<String> systemPropertyList = new ArrayList<String>();
            System.getProperties().keySet().forEach(property -> systemPropertyList.add(String.format("-D%s=%s", property, System.getProperty(property.toString()))));
            systemPropertyList.removeIf(systemProperty -> systemProperty.startsWith("-Dcucumber"));
            return systemPropertyList;
        }
    }
}

