/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgettePickleMatcher;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.internal.gherkin.pickles.PickleLocation;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class CourgetteLoader {
    private final CourgetteProperties courgetteProperties;
    private final List<Feature> features;
    private final Filters filters;

    public CourgetteLoader(CourgetteProperties courgetteProperties) {
        this.courgetteProperties = courgetteProperties;
        RuntimeOptions runtimeOptions = this.createRuntimeOptions();
        this.filters = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        TimeServiceEventBus eventBus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)eventBus).generateId());
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (Options)runtimeOptions, parser);
        this.features = featureSupplier.get();
    }

    public List<Feature> getFeatures() {
        return this.filterFeatures();
    }

    public Map<PickleLocation, Feature> getCucumberScenarios() {
        return this.filterCucumberScenarios(this.features);
    }

    private RuntimeOptions createRuntimeOptions() {
        return new CourgetteRuntimeOptions(this.courgetteProperties).getRuntimeOptions();
    }

    private List<Feature> filterFeatures() {
        ArrayList<Feature> matchedFeatures = new ArrayList<Feature>();
        this.features.forEach(feature -> {
            CourgettePickleMatcher pickleMatcher = new CourgettePickleMatcher((Feature)feature, this.filters);
            if (pickleMatcher.matches()) {
                matchedFeatures.add((Feature)feature);
            }
        });
        return matchedFeatures;
    }

    private Map<PickleLocation, Feature> filterCucumberScenarios(List<Feature> features) {
        HashMap<PickleLocation, Feature> scenarios = new HashMap<PickleLocation, Feature>();
        if (features != null) {
            features.forEach(feature -> feature.getPickles().forEach(pickle -> {
                CourgettePickleMatcher pickleMatcher = new CourgettePickleMatcher((Feature)feature, this.filters);
                PickleLocation pickleLocation = pickleMatcher.matchLocation(pickle.getLocation().getLine());
                if (pickleLocation != null) {
                    scenarios.put(pickleLocation, (Feature)feature);
                }
            }));
        }
        return scenarios;
    }
}

