/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.integration.reportportal.ReportPortalProperties;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CourgetteReporter {
    private final String reportFile;
    private final Map<String, CopyOnWriteArrayList<String>> reports;
    private final CourgetteProperties courgetteProperties;

    public CourgetteReporter(String reportFile, Map<String, CopyOnWriteArrayList<String>> reports, CourgetteProperties courgetteProperties) {
        this.reportFile = reportFile;
        this.courgetteProperties = courgetteProperties;
        reports.values().removeIf(t -> t.contains(null) || t.contains("null") || t.contains("[]") || t.contains(""));
        this.reports = reports;
    }

    public void createReport(boolean mergeTestCaseName) {
        if (this.reportFile != null && !this.reports.isEmpty()) {
            LinkedHashMap<String, CopyOnWriteArrayList<String>> reports = new LinkedHashMap<String, CopyOnWriteArrayList<String>>();
            this.reports.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                CopyOnWriteArrayList cfr_ignored_0 = (CopyOnWriteArrayList)reports.put((String)x.getKey(), (CopyOnWriteArrayList<String>)x.getValue());
            });
            ArrayList<String> reportData = new ArrayList<String>();
            reports.values().forEach(report -> {
                try {
                    reportData.add((String)report.get(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            boolean isHtml = this.reportFile.endsWith("report.js");
            boolean isJson = this.reportFile.endsWith(".json");
            boolean isXml = this.reportFile.endsWith(".xml");
            if (isHtml) {
                this.createHtmlReportImagesFolder();
                this.processNewEmbeddedHtmlFiles(reports, reportData);
                this.removeExistingEmbeddedHtmlFiles();
                reportData.removeIf(report -> !report.startsWith("$(document)"));
                FileUtils.writeFile(this.reportFile, reportData);
            }
            if (isJson) {
                reportData.removeIf(report -> !report.startsWith("["));
                FileUtils.writeFile(this.reportFile, this.formatJsonReport(reportData));
            }
            if (isXml) {
                reportData.removeIf(report -> !report.startsWith("<?xml"));
                FileUtils.writeFile(this.reportFile, this.formatXmlReport(reportData, mergeTestCaseName));
            }
        }
    }

    private String formatJsonReport(List<String> reports) {
        StringBuilder jsonBuilder = new StringBuilder("[");
        reports.forEach(data -> jsonBuilder.append((CharSequence)data, 1, data.length() - 1).append(","));
        jsonBuilder.deleteCharAt(jsonBuilder.lastIndexOf(","));
        jsonBuilder.append("]");
        return jsonBuilder.toString();
    }

    private String formatXmlReport(List<String> reports, boolean mergeTestCaseName) {
        int failures = 0;
        int skipped = 0;
        int tests = 0;
        double time = 0.0;
        String testSuite = "Test Suite";
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        xmlBuilder.append("<testsuite failures=\"id:failures\" name=\"id:testSuite\" skipped=\"id:skipped\" tests=\"id:tests\" time=\"id:time\">\n\n");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            for (String report : reports) {
                Document document = builder.parse(new InputSource(new StringReader(report)));
                if (document == null) continue;
                Element node = document.getDocumentElement();
                failures += Integer.parseInt(node.getAttribute("failures"));
                skipped += Integer.parseInt(node.getAttribute("skipped"));
                tests += Integer.parseInt(node.getAttribute("tests"));
                time += Double.parseDouble(node.getAttribute("time"));
                NodeList testCases = document.getElementsByTagName("testcase");
                if (testCases == null) continue;
                for (int i = 0; i < testCases.getLength(); ++i) {
                    Node testcase = testCases.item(i);
                    if (mergeTestCaseName) {
                        Node testClassName = testcase.getAttributes().getNamedItem("classname");
                        Node testName = testcase.getAttributes().getNamedItem("name");
                        String classNameValue = testClassName.getNodeValue();
                        String testNameValue = testName.getNodeValue();
                        testName.setNodeValue(classNameValue + ": " + testNameValue);
                    }
                    StringWriter sw = new StringWriter();
                    try {
                        Transformer t = TransformerFactory.newInstance().newTransformer();
                        t.setOutputProperty("omit-xml-declaration", "yes");
                        t.setOutputProperty("indent", "yes");
                        t.transform(new DOMSource(testcase), new StreamResult(sw));
                        xmlBuilder.append(sw.toString()).append("\n");
                        continue;
                    }
                    catch (TransformerException te) {
                        te.printStackTrace();
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        xmlBuilder.append("</testsuite>");
        if (this.courgetteProperties.isReportPortalPluginEnabled()) {
            testSuite = ReportPortalProperties.getInstance().getTestSuite();
        }
        return xmlBuilder.toString().replace("id:failures", String.valueOf(failures)).replace("id:skipped", String.valueOf(skipped)).replace("id:tests", String.valueOf(tests)).replace("id:time", String.valueOf(time)).replace("id:testSuite", testSuite);
    }

    private void processNewEmbeddedHtmlFiles(Map<String, CopyOnWriteArrayList<String>> sortedReports, List<String> reportData) {
        Stream<Map.Entry> reportsWithEmbeddedFiles = sortedReports.entrySet().stream().filter(r -> ((String)r.getKey()).contains(".html"));
        File targetDir = new File(this.reportFile).getParentFile();
        String target = targetDir.getPath();
        String targetImageFolder = "images";
        reportsWithEmbeddedFiles.forEach(report -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            try {
                String reportDetails = (String)((CopyOnWriteArrayList)report.getValue()).get(0);
                Integer reportIndex = reportData.indexOf(reportDetails);
                String[] embeddedFiles = reportDetails.split("embedded");
                for (int index = 0; index < embeddedFiles.length - 1; ++index) {
                    List reportFiles = FileUtils.getParentFiles((String)report.getKey()).stream().filter(name -> name.getName().startsWith("embedded")).collect(Collectors.toList());
                    File source = (File)reportFiles.get(index);
                    String fileExtension = source.getName().substring(source.getName().lastIndexOf(".") + 1);
                    String embeddedImageFilename = String.format("%s/%s%s.%s", "images", uuid, index, fileExtension);
                    File destination = new File(String.format("%s/%s", target, embeddedImageFilename));
                    Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    reportData.set(reportIndex, reportDetails.replace("embedded", String.format("%s/%s", "images", uuid)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createHtmlReportImagesFolder() {
        File reportTargetChild = new File(this.reportFile);
        File reportTargetParent = reportTargetChild.getParentFile();
        File imageFolder = new File(reportTargetParent.getPath() + "/images");
        if (!imageFolder.exists()) {
            imageFolder.mkdir();
        }
    }

    private void removeExistingEmbeddedHtmlFiles() {
        File reportTargetChild = new File(this.reportFile);
        File reportTargetParent = reportTargetChild.getParentFile();
        ArrayList embeddedFiles = new ArrayList();
        embeddedFiles.addAll(Arrays.stream(reportTargetParent.listFiles()).filter(file -> file.getName().startsWith("embedded")).collect(Collectors.toList()));
        embeddedFiles.forEach(File::delete);
    }
}

