/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import io.cucumber.core.gherkin.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CourgetteRunnerInfo {
    private final CourgetteRuntimeOptions courgetteRuntimeOptions;
    private final Integer lineId;
    private final CourgetteRunLevel courgetteRunLevel;
    private final Feature feature;

    public CourgetteRunnerInfo(CourgetteProperties courgetteProperties, Feature feature, Integer lineId) {
        this.feature = feature;
        this.courgetteRuntimeOptions = new CourgetteRuntimeOptions(courgetteProperties, feature);
        this.lineId = lineId;
        this.courgetteRunLevel = courgetteProperties.getCourgetteOptions().runLevel();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Integer getLineId() {
        return this.lineId;
    }

    public Map<String, List<String>> getRuntimeOptions() {
        Map<String, List<String>> runtimeOptions = this.courgetteRuntimeOptions.mapRuntimeOptions();
        if (this.courgetteRunLevel.equals((Object)CourgetteRunLevel.SCENARIO) && this.lineId != null) {
            String featurePath = runtimeOptions.get(null).get(0);
            ArrayList<String> scenarioPath = new ArrayList<String>();
            scenarioPath.add(String.format("%s:%s", featurePath, this.lineId));
            runtimeOptions.put(null, scenarioPath);
            runtimeOptions.remove("--tags");
        }
        return runtimeOptions;
    }

    public Map<String, List<String>> getRerunRuntimeOptions(String rerun) {
        Map<String, List<String>> rerunRuntimeOptions = this.getRuntimeOptions();
        rerunRuntimeOptions.remove("--tags");
        ArrayList<String> scenarioPath = new ArrayList<String>();
        scenarioPath.add(rerun);
        rerunRuntimeOptions.put(null, scenarioPath);
        return rerunRuntimeOptions;
    }

    public String getRerunFile() {
        return this.courgetteRuntimeOptions.getRerunFile();
    }

    public List<String> getReportFiles() {
        return this.courgetteRuntimeOptions.getReportJsFiles();
    }
}

