/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CucumberOptions;
import courgette.integration.reportportal.ReportPortalProperties;
import courgette.runtime.CourgetteProperties;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.RuntimeOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class CourgetteRuntimeOptions {
    private final CourgetteProperties courgetteProperties;
    private final Feature feature;
    private final CucumberOptions cucumberOptions;
    private final String reportTargetDir;
    private List<String> runtimeOptions = new ArrayList<String>();
    private String rerunFile;
    private String cucumberResourcePath;
    private final int instanceId = UUID.randomUUID().hashCode();
    private BiFunction<String, String[], String[]> envCucumberOptionParser = (systemPropertyName, cucumberOptions) -> {
        String cucumberOption = System.getProperty("cucumber." + systemPropertyName);
        if (cucumberOption != null && cucumberOption.trim().length() > 0) {
            ArrayList options = new ArrayList();
            Arrays.stream(cucumberOption.split(",")).forEach(t -> options.add(t.trim()));
            String[] cucumberOptionArray = new String[options.size()];
            return options.toArray(cucumberOptionArray);
        }
        return cucumberOptions;
    };
    private Function<CourgetteProperties, String> cucumberRerunPlugin = courgetteProperties -> {
        String rerunPlugin = Arrays.stream(courgetteProperties.getCourgetteOptions().cucumberOptions().plugin()).filter(p -> p.startsWith("rerun")).findFirst().orElse(null);
        if (rerunPlugin != null) {
            return rerunPlugin.substring(rerunPlugin.indexOf(":") + 1);
        }
        return null;
    };
    private final Predicate<String> isReportPlugin = plugin -> plugin.startsWith("html:") || plugin.startsWith("json:") || plugin.startsWith("junit:");
    private BiFunction<String, Object, List<String>> optionParser = (name, options) -> {
        ArrayList<String> runOptions = new ArrayList<String>();
        Boolean isStringArray = options instanceof String[];
        if (options == null || isStringArray.booleanValue() && ((String[])options).length == 0) {
            return runOptions;
        }
        if (isStringArray.booleanValue()) {
            String[] optionArray = (String[])options;
            Arrays.asList(Arrays.asList(optionArray).toString().split(",")).forEach(value -> {
                runOptions.add((String)name);
                runOptions.add(value.trim().replace("[", "").replace("]", ""));
            });
        } else {
            if (name != null) {
                runOptions.add((String)name);
            }
            runOptions.add(options.toString());
        }
        return runOptions;
    };
    private BiFunction<String[], String, List<String>> featureParser = (resourceFeaturePaths, featurePath) -> {
        ArrayList<String> featurePaths = new ArrayList<String>();
        if (featurePath == null) {
            featurePaths.addAll(Arrays.asList(resourceFeaturePaths));
        } else {
            featurePaths.add((String)featurePath);
        }
        return featurePaths;
    };

    public CourgetteRuntimeOptions(CourgetteProperties courgetteProperties2, Feature feature) {
        this.courgetteProperties = courgetteProperties2;
        this.feature = feature;
        this.cucumberOptions = courgetteProperties2.getCourgetteOptions().cucumberOptions();
        this.cucumberResourcePath = feature.getUri().getSchemeSpecificPart();
        this.reportTargetDir = courgetteProperties2.getCourgetteOptions().reportTargetDir();
        this.createRuntimeOptions(this.cucumberOptions, this.cucumberResourcePath).forEach((key, value) -> this.runtimeOptions.addAll((Collection<String>)value));
    }

    public CourgetteRuntimeOptions(CourgetteProperties courgetteProperties2) {
        this.courgetteProperties = courgetteProperties2;
        this.cucumberOptions = courgetteProperties2.getCourgetteOptions().cucumberOptions();
        this.feature = null;
        this.reportTargetDir = courgetteProperties2.getCourgetteOptions().reportTargetDir();
        this.createRuntimeOptions(this.cucumberOptions, null).forEach((key, value) -> this.runtimeOptions.addAll((Collection<String>)value));
    }

    public RuntimeOptions getRuntimeOptions() {
        return new CommandlineOptionsParser().parse(this.runtimeOptions).build();
    }

    public Map<String, List<String>> mapRuntimeOptions() {
        return this.createRuntimeOptions(this.cucumberOptions, this.cucumberResourcePath);
    }

    public String getRerunFile() {
        return this.rerunFile;
    }

    public String getCucumberRerunFile() {
        String cucumberRerunFile = this.cucumberRerunPlugin.apply(this.courgetteProperties);
        if (cucumberRerunFile == null) {
            return this.getRerunFile();
        }
        return cucumberRerunFile;
    }

    public List<String> getReportJsFiles() {
        ArrayList<String> reportFiles = new ArrayList<String>();
        this.runtimeOptions.forEach(option -> {
            if (option != null && this.isReportPlugin.test((String)option)) {
                String reportFile = option.substring(option.indexOf(":") + 1);
                if (option.startsWith("html:")) {
                    reportFile = reportFile + "/report.js";
                }
                reportFiles.add(reportFile);
            }
        });
        return reportFiles;
    }

    public String getCourgetteReportDataDirectory() {
        return this.reportTargetDir + "/courgette-report/data";
    }

    public String getCourgetteReportJson() {
        return String.format("%s/report.json", this.getCourgetteReportDataDirectory());
    }

    public String getCourgetteReportXmlForReportPortal() {
        ReportPortalProperties reportPortalProperties = ReportPortalProperties.getInstance();
        return String.format("%s/%s.xml", this.getCourgetteReportDataDirectory(), reportPortalProperties.getLaunchName());
    }

    private Map<String, List<String>> createRuntimeOptions(CucumberOptions cucumberOptions, String path) {
        HashMap<String, List<String>> runtimeOptions = new HashMap<String, List<String>>();
        runtimeOptions.put("--glue", this.optionParser.apply("--glue", this.envCucumberOptionParser.apply("glue", cucumberOptions.glue())));
        runtimeOptions.put("--extraGlue", this.optionParser.apply("--glue", this.envCucumberOptionParser.apply("extraGlue", cucumberOptions.extraGlue())));
        runtimeOptions.put("--tags", this.optionParser.apply("--tags", this.envCucumberOptionParser.apply("tags", cucumberOptions.tags())));
        runtimeOptions.put("--plugin", this.optionParser.apply("--plugin", this.parsePlugins(this.envCucumberOptionParser.apply("plugin", cucumberOptions.plugin()))));
        runtimeOptions.put("--name", this.optionParser.apply("--name", this.envCucumberOptionParser.apply("name", cucumberOptions.name())));
        runtimeOptions.put("--snippets", this.optionParser.apply("--snippets", cucumberOptions.snippets().name().toLowerCase()));
        runtimeOptions.put("--dryRun", Collections.singletonList(cucumberOptions.dryRun() ? "--dry-run" : "--no-dry-run"));
        runtimeOptions.put("--strict", Collections.singletonList(cucumberOptions.strict() ? "--strict" : "--no-strict"));
        runtimeOptions.put("--monochrome", Collections.singletonList(cucumberOptions.monochrome() ? "--monochrome" : "--no-monochrome"));
        runtimeOptions.put(null, this.featureParser.apply(this.envCucumberOptionParser.apply("features", cucumberOptions.features()), path));
        if (!cucumberOptions.objectFactory().getName().equals("courgette.runtime.CourgetteNoObjectFactory")) {
            runtimeOptions.put("--object-factory", this.optionParser.apply("--object-factory", cucumberOptions.objectFactory().getName()));
        }
        runtimeOptions.values().removeIf(Objects::isNull);
        return runtimeOptions;
    }

    private String getMultiThreadRerunFile() {
        return this.getTempDirectory() + this.courgetteProperties.getSessionId() + "_rerun_" + this.getFeatureId(this.feature) + ".txt";
    }

    private String getMultiThreadReportFile() {
        return this.getTempDirectory() + this.courgetteProperties.getSessionId() + "_thread_report_" + this.getFeatureId(this.feature);
    }

    private String getFeatureId(Feature feature) {
        return String.format("%s_%s", feature.hashCode(), this.instanceId);
    }

    private String[] parsePlugins(String[] plugins) {
        ArrayList<String> pluginList = new ArrayList<String>();
        if (plugins.length == 0) {
            plugins = new String[]{"json:" + this.getCourgetteReportJson()};
        }
        Arrays.asList(plugins).forEach(plugin -> {
            if (this.isReportPlugin.test((String)plugin)) {
                if (this.feature != null) {
                    pluginList.add((String)plugin);
                    String extension = plugin.substring(0, plugin.indexOf(":"));
                    if (extension.equalsIgnoreCase("junit")) {
                        pluginList.remove(plugin);
                        String reportPath = String.format("junit:%s.xml", this.getMultiThreadReportFile());
                        pluginList.add(reportPath);
                    } else if (!extension.equals("")) {
                        String reportPath = String.format("%s:%s.%s", extension, this.getMultiThreadReportFile(), extension);
                        pluginList.add(reportPath);
                    }
                } else {
                    pluginList.add((String)plugin);
                }
            } else {
                pluginList.add((String)plugin);
            }
        });
        Predicate<List> alreadyAddedRerunPlugin = addedPlugins -> addedPlugins.stream().anyMatch(p -> p.startsWith("rerun:"));
        if (!alreadyAddedRerunPlugin.test(pluginList)) {
            String cucumberRerunFile;
            this.rerunFile = this.feature != null ? this.getMultiThreadRerunFile() : ((cucumberRerunFile = this.cucumberRerunPlugin.apply(this.courgetteProperties)) != null ? cucumberRerunFile : String.format("%s/courgette-rerun.txt", this.reportTargetDir));
            pluginList.add("rerun:" + this.rerunFile);
        }
        if (pluginList.stream().noneMatch(plugin -> plugin.contains(this.getCourgetteReportJson()))) {
            pluginList.add("json:" + this.getCourgetteReportJson());
        }
        if (this.courgetteProperties.isReportPortalPluginEnabled() && pluginList.stream().noneMatch(plugin -> plugin.contains(this.getCourgetteReportXmlForReportPortal()))) {
            pluginList.add("junit:" + this.getCourgetteReportXmlForReportPortal());
        }
        if (this.feature != null) {
            String junitReportPlugin = String.format("junit:%s.xml", this.getMultiThreadReportFile());
            if (pluginList.stream().noneMatch(plugin -> plugin.equals(junitReportPlugin))) {
                pluginList.add(junitReportPlugin);
            }
        }
        return (String[])Arrays.copyOf(pluginList.toArray(), pluginList.size(), String[].class);
    }

    private String getTempDirectory() {
        String fileSeparator = File.separator;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith(fileSeparator)) {
            return tmpDir + fileSeparator;
        }
        return tmpDir;
    }
}

