/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.junit;

import courgette.runtime.CourgetteCallbacks;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteTestFailureException;
import io.cucumber.core.gherkin.Feature;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public abstract class CourgetteJUnitRunner
extends ParentRunner<Feature> {
    protected CourgetteProperties courgetteProperties;
    protected List<Feature> features;
    protected List<CourgetteRunnerInfo> runnerInfoList;
    protected CourgetteCallbacks callbacks;
    protected Description description;
    private Map<Feature, Description> featureDescriptions = new HashMap<Feature, Description>();
    private List<String> featureDescriptionNames = new ArrayList<String>();

    protected CourgetteJUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<Feature> getChildren() {
        return this.features;
    }

    protected Description describeChild(Feature child) {
        return this.description;
    }

    public Description getDescription() {
        this.createDescription();
        return this.description;
    }

    protected void runChild(Feature child, RunNotifier notifier) {
    }

    protected String createSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private void createDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Annotation[])new Annotation[0]);
        }
        this.getChildren().stream().distinct().forEach(feature -> {
            if (!this.featureDescriptionNames.contains(feature.getName())) {
                Description featureDescription = Description.createTestDescription((String)"", (String)feature.getName(), (Annotation[])new Annotation[0]);
                this.description.addChild(featureDescription);
                this.featureDescriptions.put((Feature)feature, featureDescription);
                this.featureDescriptionNames.add(feature.getName());
            }
        });
    }

    protected void notifyTestStarted(RunNotifier notifier) {
        this.featureDescriptions.values().forEach(arg_0 -> ((RunNotifier)notifier).fireTestStarted(arg_0));
    }

    protected void notifyTestSuccess(RunNotifier notifier) {
        this.featureDescriptions.values().forEach(arg_0 -> ((RunNotifier)notifier).fireTestFinished(arg_0));
    }

    protected void notifyTestFailure(RunNotifier notifier, List<CourgetteRunResult> failures) {
        failures.forEach(failure -> {
            Feature feature = failure.getFeature();
            Description description = this.featureDescriptions.get(feature);
            notifier.fireTestFailure(new Failure(description, (Throwable)new CourgetteTestFailureException("Please refer to Courgette / Cucumber report for more info.")));
        });
        this.featureDescriptions.keySet().removeAll(failures.stream().map(CourgetteRunResult::getFeature).collect(Collectors.toList()));
    }
}

