/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.report.model;

import courgette.runtime.report.model.Embedding;
import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Result;
import io.cucumber.core.backend.Status;
import java.util.List;

public class Step {
    private String name;
    private String keyword;
    private Result result;
    private List<Hook> before;
    private List<Hook> after;
    private List<Embedding> embeddings;
    private List<String> output;
    private List<String> rowData;

    public Step(String name, String keyword, Result result, List<Hook> before, List<Hook> after, List<Embedding> embeddings, List<String> output, List<String> rowData) {
        this.name = name;
        this.keyword = keyword;
        this.result = result;
        this.before = before;
        this.after = after;
        this.embeddings = embeddings;
        this.output = output;
        this.rowData = rowData;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Result getResult() {
        return this.result;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    public List<Embedding> getEmbeddings() {
        return this.embeddings;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public List<String> getRowData() {
        return this.rowData;
    }

    public boolean passed(boolean isStrict) {
        if (isStrict) {
            return this.result.getStatus().equalsIgnoreCase(Status.PASSED.toString()) || this.result.getStatus().equalsIgnoreCase(Status.SKIPPED.toString());
        }
        return !this.result.getStatus().equalsIgnoreCase(Status.FAILED.toString()) && !this.result.getStatus().equalsIgnoreCase(Status.AMBIGUOUS.toString());
    }

    public boolean skipped() {
        return this.result.getStatus().equalsIgnoreCase(Status.SKIPPED.toString()) || this.result.getStatus().equalsIgnoreCase(Status.AMBIGUOUS.toString());
    }
}

