/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.junit;

import courgette.runtime.CourgetteCallbacks;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteTestErrorException;
import courgette.runtime.RunStatus;
import courgette.runtime.junit.CourgetteJUnitRunner;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.gherkin.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class Courgette
extends CourgetteJUnitRunner {
    public Courgette(Class clazz) throws InitializationError {
        super(clazz);
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(clazz);
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, this.createSessionId(), courgetteOptions.threads());
        this.callbacks = new CourgetteCallbacks(clazz);
        CourgetteLoader courgetteLoader = new CourgetteLoader(this.courgetteProperties);
        this.features = courgetteLoader.getFeatures();
        this.runnerInfoList = new ArrayList();
        if (this.courgetteProperties.isFeatureRunLevel()) {
            this.features.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)feature, null)));
        } else {
            Map<Location, Feature> scenarios = courgetteLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)scenarios.get(location), location.getLine())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        RunStatus runStatus = RunStatus.ERROR;
        List<CourgetteRunResult> failures = new ArrayList<CourgetteRunResult>();
        try {
            this.callbacks.beforeAll();
            if (courgetteRunner.canRunFeatures()) {
                runStatus = courgetteRunner.run();
                if (RunStatus.OK.equals((Object)runStatus)) {
                    courgetteRunner.createCucumberReport();
                    courgetteRunner.createCourgetteReport();
                    if (this.courgetteProperties.isExtentReportsPluginEnabled()) {
                        courgetteRunner.createCourgetteExtentReports();
                    }
                    if (this.courgetteProperties.isReportPortalPluginEnabled()) {
                        courgetteRunner.publishReportToReportPortal();
                    }
                    if (!(failures = courgetteRunner.getFailures()).isEmpty()) {
                        courgetteRunner.createRerunFile();
                    }
                } else {
                    CourgetteTestErrorException.throwTestErrorException();
                }
            }
        }
        finally {
            courgetteRunner.cleanupCourgetteHtmlReportFiles();
            this.callbacks.afterAll();
            this.notifyTestStarted(notifier);
            this.notifyTestFailure(notifier, failures, runStatus);
            this.notifyTestSuccess(notifier);
        }
    }
}

