/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import courgette.integration.reportportal.ReportPortalProperties;
import courgette.runtime.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ReportPortalService {
    private final ReportPortalProperties reportPortalProperties;
    private final HttpClient httpClient;
    private final String authorization;
    private final String importUrl;
    private final String latestLaunchUrl;
    private final String API_LAUNCH_IMPORT = "api/v1/%s/launch/import";
    private final String API_LAUNCH_LATEST = "api/v1/%s/launch/latest";
    private final String API_LAUNCH_UPDATE = "api/v1/%s/launch/%d/update";
    private Integer launchId;

    private ReportPortalService(ReportPortalProperties reportPortalProperties) {
        this.reportPortalProperties = reportPortalProperties;
        this.httpClient = this.createHttpClient();
        this.authorization = "bearer " + reportPortalProperties.getApiToken();
        this.importUrl = reportPortalProperties.getEndpoint() + String.format("api/v1/%s/launch/import", reportPortalProperties.getProject());
        this.latestLaunchUrl = reportPortalProperties.getEndpoint() + String.format("api/v1/%s/launch/latest", reportPortalProperties.getProject());
    }

    public static ReportPortalService create(ReportPortalProperties reportPortalProperties) {
        return new ReportPortalService(reportPortalProperties);
    }

    public boolean publishReport(String reportFilename) {
        Optional<HttpResponse> response;
        File zipFile = FileUtils.zipFile(reportFilename, true);
        boolean published = false;
        if (zipFile.exists() && (published = this.handleOKResponse(response = this.sendMultiPartPost(zipFile)))) {
            this.setLatestLaunchId();
        }
        return published;
    }

    public void updateLaunchTags() {
        String tags = this.reportPortalProperties.getTags();
        if (this.launchId != null && !tags.isEmpty()) {
            String launchUpdateUrl = this.reportPortalProperties.getEndpoint() + String.format("api/v1/%s/launch/%d/update", this.reportPortalProperties.getProject(), this.launchId);
            String updateRequest = this.createLaunchUpdateRequest(tags);
            Optional<HttpResponse> response = this.updateLaunchTags(launchUpdateUrl, updateRequest);
            this.handleOKResponse(response);
        }
    }

    private Optional<HttpResponse> sendMultiPartPost(File file) {
        try {
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", file).build();
            HttpPost importReport = new HttpPost(this.importUrl);
            importReport.addHeader("Authorization", this.authorization);
            importReport.setEntity(entity);
            return Optional.of(this.httpClient.execute((HttpUriRequest)importReport));
        }
        catch (Exception e) {
            this.printError("publish the report", e.getMessage());
            return Optional.empty();
        }
    }

    private Optional<HttpResponse> updateLaunchTags(String launchUpdateUrl, String updateRequest) {
        HttpPut launchUpdate = new HttpPut(launchUpdateUrl);
        launchUpdate.addHeader("Authorization", this.authorization);
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(updateRequest).build();
        launchUpdate.setEntity(entity);
        try {
            return Optional.ofNullable(this.httpClient.execute((HttpUriRequest)launchUpdate));
        }
        catch (Exception e) {
            this.printError("update launch tags", e.getMessage());
            return Optional.empty();
        }
    }

    private void setLatestLaunchId() {
        HttpGet latestLaunch = new HttpGet(this.latestLaunchUrl);
        latestLaunch.addHeader("Authorization", this.authorization);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)latestLaunch);
            if (response.getStatusLine().getStatusCode() == 200) {
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                Optional<Integer> id = this.extractLaunchId(body);
                id.ifPresent(i -> {
                    this.launchId = i;
                });
            }
        }
        catch (Exception e) {
            this.printError("get the latest launch id", e.getMessage());
        }
    }

    private Optional<Integer> extractLaunchId(String body) {
        JsonElement json = JsonParser.parseString((String)body);
        if (json instanceof JsonNull) {
            return Optional.empty();
        }
        JsonElement content = json.getAsJsonObject().get("content");
        if (content instanceof JsonNull) {
            return Optional.empty();
        }
        JsonArray contentDetails = content.getAsJsonArray();
        JsonElement id = contentDetails.get(contentDetails.size() - 1).getAsJsonObject().get("id");
        return id instanceof JsonNull ? Optional.empty() : Optional.of(id.getAsInt());
    }

    private String createLaunchUpdateRequest(String tags) {
        JsonObject jsonObject = new JsonObject();
        JsonArray attributeArr = new JsonArray();
        String[] tagData = tags.split(";");
        Arrays.asList(tagData).forEach(tag -> {
            JsonObject tagObj = new JsonObject();
            tagObj.add("key", (JsonElement)JsonNull.INSTANCE);
            tagObj.add("value", (JsonElement)new JsonPrimitive(tag));
            attributeArr.add((JsonElement)tagObj);
        });
        jsonObject.add("attributes", (JsonElement)attributeArr);
        jsonObject.add("mode", (JsonElement)new JsonPrimitive("DEFAULT"));
        return jsonObject.toString();
    }

    private boolean handleOKResponse(Optional<HttpResponse> response) {
        if (!response.isPresent()) {
            return false;
        }
        if (response.get().getStatusLine().getStatusCode() != 200) {
            String body;
            try {
                body = EntityUtils.toString((HttpEntity)response.get().getEntity(), (String)"UTF-8");
            }
            catch (IOException e) {
                body = e.getMessage();
            }
            this.printError(body);
            return false;
        }
        return true;
    }

    private HttpClient createHttpClient() {
        try {
            SSLContext trustedSSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            return HttpClientBuilder.create().setSSLContext(trustedSSLContext).build();
        }
        catch (Exception e) {
            this.printError("error creating a secure http client: " + e.getMessage());
            return HttpClientBuilder.create().build();
        }
    }

    private void printError(String error) {
        System.err.format("Courgette Report Portal Service: %s\n", error);
    }

    private void printError(String action, String error) {
        System.err.format("Courgette Report Portal Service: unable to %s on the report portal server, reason: %s\n", action, error);
    }
}

