/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteOptions;
import courgette.api.CourgetteRunLevel;
import courgette.api.HtmlReport;
import courgette.runtime.utils.SystemPropertyUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.Predicate;

public class CourgetteProperties {
    private final CourgetteOptions courgetteOptions;
    private final String sessionId;
    private final Instant sessionStartTime;
    private final Integer maxThreads;
    private final Predicate<HtmlReport> checkIfReportIsEnabled = report -> !Arrays.asList(this.getCourgetteOptions().disableHtmlReport()).contains(report);

    public CourgetteProperties(CourgetteOptions courgetteOptions, String sessionId, Integer maxThreads) {
        this.courgetteOptions = courgetteOptions;
        this.sessionId = sessionId;
        this.sessionStartTime = Instant.now();
        this.maxThreads = maxThreads;
    }

    public CourgetteOptions getCourgetteOptions() {
        return this.courgetteOptions;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Instant getSessionStartTime() {
        return this.sessionStartTime;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public boolean isReportPortalPluginEnabled() {
        return Arrays.stream(this.courgetteOptions.plugin()).anyMatch(plugin -> plugin.equalsIgnoreCase("reportportal"));
    }

    public boolean isExtentReportsPluginEnabled() {
        return Arrays.stream(this.courgetteOptions.plugin()).anyMatch(plugin -> plugin.equalsIgnoreCase("extentreports"));
    }

    public boolean isCucumberReportPublisherEnabled() {
        return SystemPropertyUtils.getBoolProperty("cucumber.publish", this.courgetteOptions.cucumberOptions().publish());
    }

    public boolean isFeatureRunLevel() {
        return CourgetteRunLevel.FEATURE.equals((Object)this.courgetteOptions.runLevel());
    }

    public boolean isCourgetteHtmlReportEnabled() {
        return this.checkIfReportIsEnabled.test(HtmlReport.COURGETTE_HTML);
    }

    public boolean isCucumberHtmlReportEnabled() {
        return this.checkIfReportIsEnabled.test(HtmlReport.CUCUMBER_HTML);
    }

    public boolean useCustomClasspath() {
        return this.courgetteOptions.classPath().length > 0;
    }
}

