/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteNdJsonCreator;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import courgette.runtime.CucumberHtmlReporter;
import courgette.runtime.CucumberJsonReporter;
import courgette.runtime.CucumberNdJsonReporter;
import courgette.runtime.CucumberReportPublisher;
import courgette.runtime.CucumberXmlReporter;
import courgette.runtime.utils.FileUtils;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.messages.Messages;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

class CourgetteReporter {
    private final Map<String, CopyOnWriteArrayList<String>> reports;
    private final List<Messages.Envelope> messages;
    private final CourgetteRuntimeOptions courgetteRuntimeOptions;
    private final CourgetteProperties courgetteProperties;

    CourgetteReporter(Map<String, CopyOnWriteArrayList<String>> reports, Map<Feature, List<List<Messages.Envelope>>> reportMessages, CourgetteRuntimeOptions courgetteRuntimeOptions, CourgetteProperties courgetteProperties) {
        this.reports = reports;
        this.courgetteRuntimeOptions = courgetteRuntimeOptions;
        this.courgetteProperties = courgetteProperties;
        this.messages = this.createMessages(reportMessages);
        if (this.hasMessages()) {
            this.createNdJsonReport(this.messages);
        }
    }

    void createCucumberReport(String reportFile, boolean mergeTestCaseName) {
        if (reportFile != null && !this.reports.isEmpty()) {
            List<String> reportData = this.getReportData();
            boolean isHtml = reportFile.endsWith(".html");
            boolean isJson = reportFile.endsWith(".json");
            boolean isNdJson = reportFile.endsWith(".ndjson");
            boolean isXml = reportFile.endsWith(".xml");
            if (isHtml && this.courgetteProperties.isCucumberHtmlReportEnabled() && this.hasMessages()) {
                CucumberHtmlReporter.createReport(reportFile, this.messages);
            }
            if (isJson) {
                reportData.removeIf(report -> !report.startsWith("["));
                CucumberJsonReporter.createReport(reportFile, reportData);
            }
            if (isNdJson && this.hasMessages() && !reportFile.equals(this.courgetteRuntimeOptions.getCourgetteReportNdJson())) {
                CucumberNdJsonReporter.copyReport(this.courgetteRuntimeOptions.getCourgetteReportNdJson(), reportFile);
            }
            if (isXml) {
                reportData.removeIf(report -> !report.startsWith("<?xml"));
                CucumberXmlReporter.createReport(reportFile, reportData, mergeTestCaseName, this.courgetteProperties.isReportPortalPluginEnabled());
            }
        }
    }

    Optional<String> publishCucumberReport() {
        File ndJsonReport;
        Optional<String> reportUrl = Optional.empty();
        if (this.courgetteProperties.isCucumberReportPublisherEnabled() && this.courgetteProperties.isCucumberHtmlReportEnabled() && this.hasMessages() && (ndJsonReport = new File(this.courgetteRuntimeOptions.getCourgetteReportNdJson())).exists()) {
            CucumberReportPublisher reportPublisher = new CucumberReportPublisher(ndJsonReport);
            reportUrl = reportPublisher.publish();
            StringBuilder out = new StringBuilder();
            if (reportUrl.isPresent()) {
                out.append("\n------------------------------------------------------------------------\n");
                out.append("Report published at: ").append(Instant.now()).append("\n");
                out.append("\nCourgette published your Cucumber Report to:\n");
                out.append(reportUrl.get());
                out.append("\n------------------------------------------------------------------------\n");
                System.out.println(out.toString());
                String reportLinkFilename = this.courgetteProperties.getCourgetteOptions().reportTargetDir() + File.separator + "cucumber-report-link.txt";
                FileUtils.writeFile(reportLinkFilename, out.toString());
            }
        }
        return reportUrl;
    }

    private List<String> getReportData() {
        ArrayList<String> reportData = new ArrayList<String>();
        LinkedHashMap reportMap = new LinkedHashMap();
        this.reports.values().removeIf(t -> t.contains(null) || t.contains("null") || t.contains("[]") || t.contains(""));
        this.reports.forEach(reportMap::put);
        reportMap.values().forEach(report -> {
            try {
                reportData.add((String)report.get(0));
            }
            catch (Exception e) {
                CourgetteException.printExceptionStackTrace(e);
            }
        });
        return reportData;
    }

    private List<Messages.Envelope> createMessages(Map<Feature, List<List<Messages.Envelope>>> reportMessages) {
        CourgetteNdJsonCreator ndJsonCreator = new CourgetteNdJsonCreator(reportMessages);
        return this.courgetteProperties.isFeatureRunLevel() ? ndJsonCreator.createFeatureMessages() : ndJsonCreator.createScenarioMessages();
    }

    private void createNdJsonReport(List<Messages.Envelope> messages) {
        CucumberNdJsonReporter.createReport(this.courgetteRuntimeOptions.getCourgetteReportNdJson(), messages);
    }

    private boolean hasMessages() {
        return this.messages != null;
    }
}

