/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.junit;

import courgette.runtime.CourgetteCallbacks;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteSession;
import courgette.runtime.CourgetteTestErrorException;
import courgette.runtime.CucumberPickleLocation;
import courgette.runtime.junit.CourgetteJUnitRunner;
import io.cucumber.core.gherkin.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class Courgette
extends CourgetteJUnitRunner {
    public Courgette(Class clazz) throws InitializationError {
        super(clazz);
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(clazz);
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, CourgetteSession.current().sessionId(), courgetteOptions.threads());
        this.callbacks = new CourgetteCallbacks(clazz);
        CourgetteLoader courgetteLoader = new CourgetteLoader(this.courgetteProperties);
        this.features = courgetteLoader.getFeatures();
        this.runnerInfoList = new ArrayList();
        if (this.courgetteProperties.isFeatureRunLevel()) {
            this.features.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)feature, null)));
        } else {
            Map<CucumberPickleLocation, Feature> scenarios = courgetteLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)scenarios.get(location), location.getLine())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        List<Object> failures = new ArrayList();
        try {
            this.callbacks.beforeAll();
            if (courgetteRunner.canRunFeatures()) {
                switch (courgetteRunner.run()) {
                    case OK: {
                        courgetteRunner.createCucumberReport();
                        courgetteRunner.createCourgetteReport();
                        courgetteRunner.createCourgettePluginReports();
                        break;
                    }
                    case REPORT_PROCESSING_ERROR: {
                        CourgetteException.printError("[Courgette Runner] There was an unexpected error processing the individual Cucumber report files and Courgette was unable to create any reports for this test run.");
                        break;
                    }
                    case ERROR: {
                        CourgetteTestErrorException.throwTestErrorException();
                    }
                }
                failures = courgetteRunner.getFailures();
                if (!failures.isEmpty()) {
                    courgetteRunner.createRerunFile();
                }
            }
        }
        finally {
            courgetteRunner.printCourgetteTestStatistics();
            courgetteRunner.printCourgetteTestFailures();
            courgetteRunner.cleanupCourgetteHtmlReportFiles();
            this.callbacks.afterAll();
            this.notifyTestStarted(notifier);
            this.notifyTestFailure(notifier, failures);
            this.notifyTestSuccess(notifier);
        }
    }
}

