/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteMobileDevice;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class CourgetteMobileDeviceAllocatorService {
    private final CopyOnWriteArrayList<CourgetteMobileDevice> availableDevices = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<CourgetteMobileDevice> unavailableDevices = new CopyOnWriteArrayList();

    public CourgetteMobileDeviceAllocatorService(String[] devices) {
        this.availableDevices.addAll(this.createCourgetteMobileDevices(devices));
    }

    public synchronized CourgetteMobileDevice allocateDevice() {
        List devices = this.availableDevices.stream().filter(device -> !this.unavailableDevices.contains(device)).collect(Collectors.toList());
        Collections.shuffle(devices);
        CourgetteMobileDevice device2 = (CourgetteMobileDevice)devices.get(0);
        this.unavailableDevices.add(device2);
        return device2;
    }

    public synchronized void deallocateDevice(CourgetteMobileDevice device) {
        this.unavailableDevices.remove(device);
    }

    private List<CourgetteMobileDevice> createCourgetteMobileDevices(String[] devices) {
        ArrayList<CourgetteMobileDevice> courgetteMobileDevices = new ArrayList<CourgetteMobileDevice>();
        this.createDeviceSet(devices).forEach(device -> {
            List deviceIdentifier = Arrays.stream(device.split(":")).map(String::trim).collect(Collectors.toList());
            String deviceName = (String)deviceIdentifier.get(0);
            if (deviceIdentifier.size() > 1) {
                courgetteMobileDevices.add(new CourgetteMobileDevice(deviceName, (String)deviceIdentifier.get(1), this.getParallelPort()));
            } else {
                courgetteMobileDevices.add(new CourgetteMobileDevice(deviceName, null, this.getParallelPort()));
            }
        });
        return courgetteMobileDevices;
    }

    private Set<String> createDeviceSet(String[] devices) {
        HashSet<String> deviceSet = new HashSet<String>();
        for (String device : devices) {
            if (!deviceSet.stream().noneMatch(d -> d.toLowerCase().equals(device.toLowerCase().trim()))) continue;
            deviceSet.add(device.trim());
        }
        return deviceSet;
    }

    private synchronized int getParallelPort() {
        int parallelPort = 0;
        try {
            ServerSocket socket = new ServerSocket(0);
            parallelPort = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            CourgetteException.printError("Courgette Mobile Device Allocator: Unable to find a free port");
        }
        return parallelPort;
    }
}

