/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteRunResult;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import java.util.List;
import java.util.Optional;

public final class CourgetteTestFailure {
    public static void printTestFailures(List<CourgetteRunResult> failures, boolean isFeatureRunLevel) {
        if (!failures.isEmpty()) {
            StringBuilder testFailures = new StringBuilder();
            testFailures.append(String.format("\nThe following %s failed: \n", isFeatureRunLevel ? "features" : "scenarios"));
            failures.forEach(failure -> {
                Optional<Pickle> scenario;
                Feature feature = failure.getFeature();
                String testId = feature.getName().orElse("Test");
                if (failure.getLineId() != null && (scenario = feature.getPickles().stream().filter(t -> t.getLocation().getLine() == failure.getLineId().intValue()).findFirst()).isPresent()) {
                    testId = testId + " - " + scenario.get().getName();
                }
                testFailures.append(testId).append("\n");
            });
            System.err.println(testFailures);
        }
    }
}

