/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunResult;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CourgetteTestStatistics {
    private int total;
    private int passed;
    private int failed;
    private int rerun;
    private int passedAfterRerun;
    private String duration;
    private static CourgetteTestStatistics instance;

    public static CourgetteTestStatistics current() {
        if (instance == null) {
            instance = new CourgetteTestStatistics();
        }
        return instance;
    }

    protected void calculate(List<CourgetteRunResult> runResults, CourgetteProperties courgetteProperties) {
        this.calculateTestStatistics(runResults, courgetteProperties);
    }

    public int total() {
        return this.total;
    }

    public int passed() {
        return this.passed;
    }

    public int failed() {
        return this.failed;
    }

    public int rerun() {
        return this.rerun;
    }

    public String duration() {
        return this.duration == null ? "0 min, 0 sec" : this.duration;
    }

    public int passedAfterRerun() {
        return this.passedAfterRerun;
    }

    public int passedPercentage() {
        return this.calculatePercentage(this.passed);
    }

    public int failedPercentage() {
        return this.calculatePercentage(this.failed);
    }

    public boolean hasFailures() {
        return this.failed > 0;
    }

    protected void printToConsole(CourgetteProperties courgetteProperties) {
        System.out.println("\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("\u001b[32m             Courgette Test Statistics          \u001b[0m");
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        System.out.println("Summary:\t" + this.passedPercentage() + "% passed" + (this.failed > 0 ? ", " + this.failedPercentage() + "% failed" : ""));
        System.out.println("Duration:\t" + this.duration());
        System.out.println("Run Level:\t" + (courgetteProperties.isFeatureRunLevel() ? "Feature" : "Scenario"));
        System.out.println("Total:\t\t" + this.total);
        System.out.println("Passed:\t\t" + this.passed);
        System.out.println("Failed:\t\t" + this.failed);
        if (courgetteProperties.getCourgetteOptions().rerunFailedScenarios()) {
            System.out.println("Rerun:\t\t" + this.rerun);
        }
        System.out.println("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
    }

    private void calculateTestStatistics(List<CourgetteRunResult> runResults, CourgetteProperties courgetteProperties) {
        this.total = (int)runResults.stream().filter(result -> !result.getStatus().equals((Object)CourgetteRunResult.Status.RERUN)).count();
        this.passed = this.calculateStatus(runResults, CourgetteRunResult.Status.PASSED, CourgetteRunResult.Status.PASSED_AFTER_RERUN);
        this.failed = this.total - this.passed;
        if (courgetteProperties.getCourgetteOptions().rerunFailedScenarios()) {
            this.rerun = this.calculateStatus(runResults, CourgetteRunResult.Status.RERUN);
            this.passedAfterRerun = this.calculateStatus(runResults, CourgetteRunResult.Status.PASSED_AFTER_RERUN);
        }
        long elapsedMill = Instant.now().minus(courgetteProperties.getSessionStartTime().toEpochMilli(), ChronoUnit.MILLIS).toEpochMilli();
        this.duration = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(elapsedMill), TimeUnit.MILLISECONDS.toSeconds(elapsedMill) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(elapsedMill)));
    }

    private int calculateStatus(List<CourgetteRunResult> runResults, CourgetteRunResult.Status ... status) {
        return (int)runResults.stream().filter(result -> Arrays.asList(status).contains((Object)result.getStatus())).count();
    }

    private int calculatePercentage(double value) {
        return (int)Math.round(value / (double)this.total * 100.0);
    }
}

