/*
 * Decompiled with CFR 0.152.
 */
package io.github.productboardlabs.kafka.serializers;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.avro.AvroMapper;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.github.productboardlabs.kafka.serializers.MessageTooLargeDeserializationException;
import io.github.productboardlabs.kafka.serializers.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJacksonKafkaAvroDeserializer
extends AbstractKafkaSchemaSerDe
implements Deserializer<Object> {
    private static final int MAGIC_BYTE_LENGTH = 1;
    private static final int SUBJECT_ID_LENGTH = 4;
    private final AvroMapper mapper = this.createAvroMapper();
    private static final int PREFIX_LENGTH = 5;
    private final int maxMessageSize;

    public AbstractJacksonKafkaAvroDeserializer() {
        this(Integer.MAX_VALUE);
    }

    public AbstractJacksonKafkaAvroDeserializer(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected abstract Class<?> getClassFor(@NotNull String var1, @NotNull Schema var2);

    @NotNull
    protected AvroMapper createAvroMapper() {
        AvroMapper mapper = Utils.createAvroMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private Object deserializePrimitive(byte[] payload, Schema schema, int dataLength) throws IOException {
        Object result = new GenericDatumReader(schema).read(null, (Decoder)DecoderFactory.get().binaryDecoder(payload, 5, dataLength, null));
        return schema.getType().equals((Object)Schema.Type.STRING) ? result.toString() : result;
    }

    private boolean isPrimitiveSchema(Schema schema) {
        return AvroSchemaUtils.getPrimitiveSchemas().containsValue(schema);
    }

    private Schema getSchema(int schemaId) throws IOException, RestClientException {
        return ((io.confluent.kafka.schemaregistry.avro.AvroSchema)this.schemaRegistry.getSchemaById(schemaId)).rawSchema();
    }

    private byte getMagicByte(byte[] payload) {
        return payload[0];
    }

    private int getSchemaId(byte[] payload) {
        return ByteBuffer.wrap(payload, 1, 4).getInt();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configureClientProperties(new AbstractKafkaSchemaSerDeConfig(AbstractKafkaSchemaSerDeConfig.baseConfigDef(), configs), (SchemaProvider)new AvroSchemaProvider());
    }

    public Object deserialize(String topic, byte[] payload) {
        if (payload == null) {
            return null;
        }
        if (this.getMagicByte(payload) != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        if (payload.length > this.maxMessageSize) {
            throw new MessageTooLargeDeserializationException(topic, payload.length, this.maxMessageSize);
        }
        int schemaId = this.getSchemaId(payload);
        try {
            Schema schema = this.getSchema(schemaId);
            int dataLength = payload.length - 5;
            if (this.isPrimitiveSchema(schema)) {
                return this.deserializePrimitive(payload, schema, dataLength);
            }
            return this.mapper.readerFor(this.getClassFor(topic, schema)).with((FormatSchema)new AvroSchema(schema)).readValue(payload, 5, dataLength);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException("Error when deserializing", e);
        }
    }

    public Object deserialize(String topic, Headers headers, byte[] payload) {
        return this.deserialize(topic, payload);
    }

    public void close() {
    }
}

