/*
 * Decompiled with CFR 0.152.
 */
package io.github.productboardlabs.kafka.serializers;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.dataformat.avro.AvroMapper;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.github.productboardlabs.kafka.serializers.SchemaMetadata;
import io.github.productboardlabs.kafka.serializers.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJacksonKafkaAvroSerializer
extends AbstractKafkaSchemaSerDe
implements Serializer<Object> {
    private final Map<String, Schema> primitiveSchemas = AvroSchemaUtils.getPrimitiveSchemas();
    private final AvroMapper mapper = this.createAvroMapper();
    private boolean autoRegisterSchema;

    @NotNull
    protected abstract SchemaMetadata getSchemaFor(@NotNull String var1, @NotNull Object var2);

    @NotNull
    protected AvroMapper createAvroMapper() {
        return Utils.createAvroMapper();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        AbstractKafkaSchemaSerDeConfig config = new AbstractKafkaSchemaSerDeConfig(AbstractKafkaSchemaSerDeConfig.baseConfigDef(), configs);
        this.configureClientProperties(config, (SchemaProvider)new AvroSchemaProvider());
        this.autoRegisterSchema = config.autoRegisterSchema();
    }

    public byte[] serialize(String topic, Object data) {
        byte[] byArray;
        if (data == null) {
            return null;
        }
        SchemaMetadata schema = this.getSchema(topic, data);
        int schemaId = this.getSchemaId(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(0);
            baos.write(ByteBuffer.allocate(4).putInt(schemaId).array());
            this.write(data, schema.getSchema(), baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializationException("Can not serialize data", (Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    protected int getSchemaId(SchemaMetadata schema) {
        try {
            if (this.autoRegisterSchema) {
                return this.schemaRegistry.register(schema.getSubject(), (ParsedSchema)new io.confluent.kafka.schemaregistry.avro.AvroSchema(schema.getSchema()));
            }
            return this.schemaRegistry.getId(schema.getSubject(), (ParsedSchema)new io.confluent.kafka.schemaregistry.avro.AvroSchema(schema.getSchema()));
        }
        catch (Exception e) {
            throw new SerializationException("Can not fetch schema", (Throwable)e);
        }
    }

    private void write(Object data, Schema schema, ByteArrayOutputStream out) throws IOException {
        if (this.isPrimitive(data)) {
            new GenericDatumWriter(schema, GenericData.get()).write(data, (Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)out, null));
        } else if (data instanceof byte[]) {
            out.write((byte[])data);
        } else {
            this.mapper.writer((FormatSchema)new AvroSchema(schema)).writeValue((OutputStream)out, data);
        }
    }

    private boolean isPrimitive(Object data) {
        return data == null || data instanceof Number || data instanceof String;
    }

    private SchemaMetadata getSchema(String topic, Object object) {
        if (object == null) {
            return this.getPrimitiveSchema("Null");
        }
        if (object instanceof Boolean) {
            return this.getPrimitiveSchema("Boolean");
        }
        if (object instanceof Integer) {
            return this.getPrimitiveSchema("Integer");
        }
        if (object instanceof Long) {
            return this.getPrimitiveSchema("Long");
        }
        if (object instanceof Float) {
            return this.getPrimitiveSchema("Float");
        }
        if (object instanceof Double) {
            return this.getPrimitiveSchema("Double");
        }
        if (object instanceof CharSequence) {
            return this.getPrimitiveSchema("String");
        }
        if (object instanceof byte[]) {
            return this.getPrimitiveSchema("Bytes");
        }
        return this.getSchemaFor(topic, object);
    }

    private SchemaMetadata getPrimitiveSchema(String type) {
        return new SchemaMetadata(this.primitiveSchemas.get(type), "null-value");
    }

    public byte[] serialize(String topic, Headers headers, Object data) {
        return this.serialize(topic, data);
    }

    public void close() {
    }
}

