/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.quarkus.xbuilder.runtime;

import io.quarkus.qute.Locate;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.Variant;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;

@Locate(value="xbuilder:*")
public class CustomTemplateLocator
implements TemplateLocator {
    public static final String PREFIX = "xbuilder:";

    public int getPriority() {
        return 0;
    }

    public Optional<TemplateLocator.TemplateLocation> locate(String path) {
        InputStream is = this.locatePath(path = path.replace(PREFIX, "templates/Renderer/"));
        if (is == null) {
            return Optional.empty();
        }
        return Optional.of(this.buildTemplateLocation(is));
    }

    private InputStream locatePath(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = CustomTemplateLocator.class.getClassLoader();
        }
        return cl.getResourceAsStream(path);
    }

    private TemplateLocator.TemplateLocation buildTemplateLocation(final InputStream is) {
        return new TemplateLocator.TemplateLocation(){

            public Reader read() {
                return new InputStreamReader(is);
            }

            public Optional<Variant> getVariant() {
                return Optional.empty();
            }
        };
    }
}

