/*
 * Decompiled with CFR 0.152.
 */
package io.github.project.openubl.xmlsenderws.webservices.providers;

import io.github.project.openubl.xmlsenderws.webservices.exceptions.WebServiceExceptionFactory;
import io.github.project.openubl.xmlsenderws.webservices.models.TicketResponseType;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceCallback;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceModel;
import io.github.project.openubl.xmlsenderws.webservices.providers.BillServiceProvider;
import io.github.project.openubl.xmlsenderws.webservices.providers.ErrorBillServiceProvider;
import io.github.project.openubl.xmlsenderws.webservices.providers.ErrorBillServiceProviderFactory;
import io.github.project.openubl.xmlsenderws.webservices.providers.ErrorBillServiceRegistry;
import io.github.project.openubl.xmlsenderws.webservices.utils.SunatErrors;
import io.github.project.openubl.xmlsenderws.webservices.utils.Utils;
import io.github.project.openubl.xmlsenderws.webservices.wrappers.BillServiceWrapper;
import io.github.project.openubl.xmlsenderws.webservices.wrappers.ServiceConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.xpath.XPathExpressionException;
import jodd.io.ZipBuilder;
import org.xml.sax.SAXException;
import service.sunat.gob.pe.billservice.StatusResponse;

public class DefaultBillServiceProvider
implements BillServiceProvider {
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(10);

    private BillServiceModel sendSummaryOrPack(String fileName, byte[] file, ServiceConfig config, boolean isSummary) {
        BillServiceModel result;
        block6: {
            if (fileName.endsWith(".xml")) {
                try {
                    file = ZipBuilder.createZipInMemory().add(file).path(fileName).save().toBytes();
                    fileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".zip";
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            result = null;
            try {
                String ticket = isSummary ? BillServiceWrapper.sendSummary(fileName, file, null, config) : BillServiceWrapper.sendPack(fileName, file, null, config);
                result = Utils.toModel(ticket);
            }
            catch (SOAPFaultException e) {
                Set<ErrorBillServiceProviderFactory> factories = ErrorBillServiceRegistry.getInstance().getFactories(e);
                for (ErrorBillServiceProviderFactory factory : factories) {
                    int exceptionCode;
                    ErrorBillServiceProvider provider = factory.create(exceptionCode = Utils.getErrorCode(e).orElseThrow(() -> new IllegalArgumentException("Could not get Sunat exception code")).intValue());
                    BillServiceModel handledResult = provider.sendSummary(fileName, file, config);
                    if (handledResult == null) continue;
                    result = handledResult;
                }
                if (result != null) break block6;
                throw WebServiceExceptionFactory.createWebServiceException(e);
            }
        }
        return result;
    }

    private void sendSummaryOrPackCallback(ServiceConfig config, String ticket, BillServiceCallback callback, Map<String, Object> params, long delay) {
        Runnable runnable = () -> {
            try {
                BillServiceModel status = this.getStatus(ticket, config);
                switch (status.getStatus()) {
                    case ACEPTADO: {
                        callback.onSuccess(params, status.getCode(), status.getDescription(), status.getCdr());
                        break;
                    }
                    case RECHAZADO: {
                        callback.onError(params, status.getCode(), status.getDescription(), status.getCdr());
                        break;
                    }
                    case BAJA: {
                        throw new IllegalStateException("Invalid status result=" + (Object)((Object)status.getStatus()));
                    }
                    case EXCEPCION: {
                        callback.onException(params, status.getCode(), status.getDescription());
                        break;
                    }
                    case EN_PROCESO: {
                        callback.onProcess(params, status.getCode(), status.getDescription());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected status=" + (Object)((Object)status.getStatus()));
                    }
                }
            }
            catch (SOAPFaultException e) {
                callback.onThrownException(params, e);
            }
        };
        this.executorService.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public BillServiceModel sendBill(String fileName, byte[] file, ServiceConfig config) {
        if (fileName.endsWith(".xml")) {
            try {
                file = ZipBuilder.createZipInMemory().add(file).path(fileName).save().toBytes();
                fileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".zip";
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            byte[] zip = BillServiceWrapper.sendBill(fileName, file, null, config);
            BillServiceModel result = Utils.toModel(zip);
            Integer statusCode = result.getCode();
            if (statusCode != null) {
                Set<ErrorBillServiceProviderFactory> factories = ErrorBillServiceRegistry.getInstance().getFactories(statusCode);
                for (ErrorBillServiceProviderFactory factory : factories) {
                    ErrorBillServiceProvider provider = factory.create(statusCode, result);
                    BillServiceModel handledResult = provider.sendBill(fileName, file, config);
                    if (handledResult == null) continue;
                    result = handledResult;
                }
            }
            return result;
        }
        catch (SOAPFaultException e) {
            Set<ErrorBillServiceProviderFactory> factories = ErrorBillServiceRegistry.getInstance().getFactories(e);
            for (ErrorBillServiceProviderFactory factory : factories) {
                int exceptionCode;
                ErrorBillServiceProvider provider = factory.create(exceptionCode = Utils.getErrorCode(e).orElseThrow(() -> new IllegalArgumentException("Could not get Sunat exception code")).intValue());
                BillServiceModel handledResult = provider.sendBill(fileName, file, config);
                if (handledResult == null) continue;
                return handledResult;
            }
            throw WebServiceExceptionFactory.createWebServiceException(e);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public BillServiceModel sendSummary(String fileName, byte[] file, ServiceConfig config) {
        return this.sendSummary(fileName, file, config, Collections.emptyMap(), null, -1L);
    }

    @Override
    public BillServiceModel sendSummary(String fileName, byte[] file, ServiceConfig config, Map<String, Object> params, BillServiceCallback callback, long delay) {
        BillServiceModel result = this.sendSummaryOrPack(fileName, file, config, true);
        if (callback != null) {
            this.sendSummaryOrPackCallback(config, result.getTicket(), callback, params, delay);
        }
        return result;
    }

    @Override
    public BillServiceModel sendPack(String fileName, byte[] file, ServiceConfig config) {
        return this.sendPack(fileName, file, config, Collections.emptyMap(), null, -1L);
    }

    @Override
    public BillServiceModel sendPack(String fileName, byte[] file, ServiceConfig config, Map<String, Object> params, BillServiceCallback callback, long delay) {
        BillServiceModel result = this.sendSummaryOrPack(fileName, file, config, false);
        if (callback != null) {
            this.sendSummaryOrPackCallback(config, result.getTicket(), callback, params, delay);
        }
        return result;
    }

    private static BillServiceModel getStatus(String ticket, ServiceConfig config, int statusCode, BillServiceModel previousModel) {
        Set<ErrorBillServiceProviderFactory> factories = ErrorBillServiceRegistry.getInstance().getFactories(statusCode);
        for (ErrorBillServiceProviderFactory factory : factories) {
            ErrorBillServiceProvider provider = factory.create(statusCode, previousModel);
            BillServiceModel result = provider.getStatus(ticket, config);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public BillServiceModel getStatus(String ticket, ServiceConfig config) {
        int statusCode;
        byte[] zip;
        try {
            StatusResponse statusResponse = BillServiceWrapper.getStatus(ticket, config);
            zip = statusResponse.getContent();
            statusCode = Integer.parseInt(statusResponse.getStatusCode());
        }
        catch (SOAPFaultException e) {
            Set<ErrorBillServiceProviderFactory> factories = ErrorBillServiceRegistry.getInstance().getFactories(e);
            for (ErrorBillServiceProviderFactory factory : factories) {
                int exceptionCode;
                ErrorBillServiceProvider provider = factory.create(exceptionCode = Utils.getErrorCode(e).orElseThrow(() -> new IllegalArgumentException("Could not get Sunat exception code")).intValue());
                BillServiceModel handledResult = provider.getStatus(ticket, config);
                if (handledResult == null) continue;
                return handledResult;
            }
            throw WebServiceExceptionFactory.createWebServiceException(e);
        }
        try {
            BillServiceModel result;
            if (statusCode == TicketResponseType.PROCESO_CORRECTAMENTE.getCode()) {
                result = Utils.toModel(zip);
            } else if (statusCode == TicketResponseType.PROCESO_CON_ERRORES.getCode()) {
                BillServiceModel firstResult = Utils.toModel(zip);
                result = DefaultBillServiceProvider.getStatus(ticket, config, 99, firstResult);
                if (result == null) {
                    result = DefaultBillServiceProvider.getStatus(ticket, config, firstResult.getCode(), firstResult);
                }
                if (result == null) {
                    result = firstResult;
                }
                result.setTicket(ticket);
            } else if (statusCode == TicketResponseType.EN_PROCESO.getCode()) {
                result = new BillServiceModel();
                result.setCdr(zip);
                result.setTicket(ticket);
                result.setCode(statusCode);
                result.setStatus(BillServiceModel.Status.EN_PROCESO);
                result.setDescription(TicketResponseType.EN_PROCESO.getDescription());
            } else {
                result = DefaultBillServiceProvider.getStatus(ticket, config, statusCode, null);
                if (result == null) {
                    String errorDescription = SunatErrors.getInstance().get(statusCode);
                    result = new BillServiceModel();
                    result.setCdr(zip);
                    result.setCode(statusCode);
                    result.setTicket(ticket);
                    result.setStatus(BillServiceModel.Status.fromCode(statusCode));
                    result.setDescription(errorDescription);
                }
            }
            result.setTicket(ticket);
            return result;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }
}

